/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.stubs.CssStylesheetStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StylesheetFileBase
extends PsiFileBase
implements StylesheetFile {
    protected StylesheetFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/css/impl/StylesheetFileBase", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/css/impl/StylesheetFileBase", "<init>"));
        }
        super(viewProvider, language);
    }

    public String toString() {
        return "StylesheetFile:" + this.getName();
    }

    public CssStylesheet getStylesheet() {
        CssStylesheet nestedStylesheet;
        CssStylesheet stylesheet;
        StubElement stub = this.getStub();
        if (stub != null) {
            PsiElement psi;
            StubElement stylesheetStub = null;
            for (Object child : stub.getChildrenStubs()) {
                if (!(child instanceof StubElement) || !(((StubElement)child).getStubType() instanceof CssStylesheetStubElementType)) continue;
                stylesheetStub = (StubElement)child;
                break;
            }
            PsiElement psiElement = psi = stylesheetStub != null ? stylesheetStub.getPsi() : null;
            if (psi instanceof CssStylesheet) {
                return (CssStylesheet)psi;
            }
        }
        if ((stylesheet = (CssStylesheet)this.findChildByClass(CssStylesheet.class)) != null && (nestedStylesheet = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)stylesheet, CssStylesheet.class)) != null) {
            return nestedStylesheet;
        }
        return stylesheet;
    }

    public boolean isImportVisibleInContext(CssImport anImport, @Nullable PsiElement context) {
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/StylesheetFileBase", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitStylesheetFile((StylesheetFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }
}

