/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssGroupAllValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupAndValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupAnyValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupOrValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorBase;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssGroupValue
extends CssValueDescriptorBase {
    private final boolean myIgnoreWhitespaces;
    @Nullable
    private final CssValueDescriptor mySeparator;
    @NotNull
    private final Collection<CssValueDescriptor> myChildren;
    @NotNull
    private final Type myType;

    protected CssGroupValue(@NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptorData valueDescriptorData, boolean ignoreWhitespaces, @Nullable CssValueDescriptor valuesSeparator, @NotNull Type type) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "<init>"));
        }
        if (valueDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "<init>"));
        }
        super(commonDescriptorData, valueDescriptorData);
        this.myChildren = new ArrayList<CssValueDescriptor>();
        this.myIgnoreWhitespaces = ignoreWhitespaces;
        this.mySeparator = valuesSeparator;
        this.myType = type;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "getType"));
        }
        return type;
    }

    public void acceptChildren(@NotNull CssValueDescriptorVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "acceptChildren"));
        }
        for (CssValueDescriptor child : this.myChildren) {
            child.accept(visitor);
        }
    }

    @NotNull
    public Collection<CssValueDescriptor> getChildren() {
        Collection<CssValueDescriptor> collection = this.myChildren;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "getChildren"));
        }
        return collection;
    }

    @Nullable
    public CssValueDescriptor getValuesSeparator() {
        return this.mySeparator;
    }

    public void addChild(@NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "addChild"));
        }
        this.myChildren.add(valueDescriptor);
    }

    public boolean isWhitespacesShouldBeIgnored() {
        return this.myIgnoreWhitespaces;
    }

    @NotNull
    public static CssGroupValue create(@NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptorData valueDescriptorData, boolean ignoreWhitespaces, @Nullable CssValueDescriptor valuesSeparator, @NotNull Type type) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
        }
        if (valueDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
        }
        switch (type) {
            case OR: {
                CssGroupOrValue cssGroupOrValue = new CssGroupOrValue(commonDescriptorData, valueDescriptorData, ignoreWhitespaces, valuesSeparator);
                if (cssGroupOrValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
                }
                return cssGroupOrValue;
            }
            case AND: {
                CssGroupAndValue cssGroupAndValue = new CssGroupAndValue(commonDescriptorData, valueDescriptorData, ignoreWhitespaces, valuesSeparator);
                if (cssGroupAndValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
                }
                return cssGroupAndValue;
            }
            case ANY: {
                CssGroupAnyValue cssGroupAnyValue = new CssGroupAnyValue(commonDescriptorData, valueDescriptorData, ignoreWhitespaces, valuesSeparator);
                if (cssGroupAnyValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
                }
                return cssGroupAnyValue;
            }
            case ALL: {
                CssGroupAllValue cssGroupAllValue = new CssGroupAllValue(commonDescriptorData, valueDescriptorData, ignoreWhitespaces, valuesSeparator);
                if (cssGroupAllValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssGroupValue", "create"));
                }
                return cssGroupAllValue;
            }
        }
        throw new IllegalArgumentException("Invalid group type");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssGroupValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssGroupValue value = (CssGroupValue)o;
        if (this.myIgnoreWhitespaces != value.myIgnoreWhitespaces) {
            return false;
        }
        if (this.myType != value.myType) {
            return false;
        }
        if (this.myType == Type.ALL && !this.myChildren.equals(value.myChildren)) {
            return false;
        }
        if (this.myType != Type.ALL && !ContainerUtil.newHashSet(this.myChildren).equals(ContainerUtil.newHashSet(value.myChildren))) {
            return false;
        }
        return !(this.mySeparator != null ? !this.mySeparator.equals(value.mySeparator) : value.mySeparator != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myIgnoreWhitespaces ? 1 : 0);
        result = 31 * result + (this.mySeparator != null ? this.mySeparator.hashCode() : 0);
        result = 31 * result + this.myChildren.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public static enum Type {
        OR,
        AND,
        ANY,
        ALL;

    }
}

