/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorBase;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import org.jetbrains.annotations.NotNull;

public class CssTextValue
extends CssValueDescriptorBase {
    @NotNull
    private final String myValue;

    public CssTextValue(@NotNull String value, @NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptorData valueDescriptorData) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/descriptor/value/CssTextValue", "<init>"));
        }
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssTextValue", "<init>"));
        }
        if (valueDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssTextValue", "<init>"));
        }
        super(commonDescriptorData, valueDescriptorData);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        this.myValue = value;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssTextValue", "getValue"));
        }
        return string;
    }

    @Override
    public void accept(CssValueDescriptorVisitor visitor) {
        if (visitor instanceof CssValueDescriptorVisitorImpl) {
            ((CssValueDescriptorVisitorImpl)visitor).visitTextValue(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssTextValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssTextValue value = (CssTextValue)o;
        return this.myValue.equals(value.myValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }
}

