/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.manipulators;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssString;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssStringManipulator
implements ElementManipulator<CssString> {
    public CssString handleContentChange(@NotNull CssString element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "handleContentChange"));
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CssString element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "getRangeInElement"));
        }
        String text = element.getText();
        int length = text.length();
        int start = 0;
        if (length == 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        char c = text.charAt(0);
        if (c == '~' && length > 1) {
            c = text.charAt(1);
            start = 1;
        }
        if (c == '\'' || c == '\"') {
            if (length == 1) {
                TextRange textRange = new TextRange(1, 1);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "getRangeInElement"));
                }
                return textRange;
            }
            ++start;
        } else {
            start = 0;
        }
        c = text.charAt(length - 1);
        TextRange textRange = new TextRange(start, c == '\'' || c == '\"' ? length - 1 : length);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public CssString handleContentChange(@NotNull CssString element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/css/impl/manipulators/CssStringManipulator", "handleContentChange"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return element;
        }
        String newText = range.replace(element.getText(), newContent);
        char quoteChar = !newText.isEmpty() && newText.charAt(0) == '\'' && newText.charAt(newText.length() - 1) == '\'' ? (char)'\'' : '\"';
        CssElementFactory elementFactory = CssElementFactory.getInstance((Project)element.getProject());
        element.getFirstChild().replace(elementFactory.createStringToken(quoteChar, StringUtil.unquoteString((String)newText), CssPsiUtil.getStylesheetLanguage((PsiElement)element)));
        return element;
    }
}

