/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssUri;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssUriManipulator
implements ElementManipulator<CssUri> {
    public CssUri handleContentChange(@NotNull CssUri element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssUriManipulator", "handleContentChange"));
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CssUri element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssUriManipulator", "getRangeInElement"));
        }
        PsiElement valueElement = element.getValueElement();
        TextRange textRange = valueElement != null ? TextRange.from((int)valueElement.getStartOffsetInParent(), (int)valueElement.getTextLength()) : TextRange.EMPTY_RANGE;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/manipulators/CssUriManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public CssUri handleContentChange(@NotNull CssUri element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssUriManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/css/impl/manipulators/CssUriManipulator", "handleContentChange"));
        }
        element.setValue(newContent);
        return element;
    }
}

