/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.impl.stubs.CssPseudoSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CssPseudoSelectorStubElementType<T extends CssPseudoSelector>
extends CssNamedStubElementType<CssPseudoSelectorStub<T>, T> {
    public CssPseudoSelectorStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public CssPseudoSelectorStub<T> createStub(@NotNull CssPseudoSelector psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "createStub"));
        }
        CssPseudoSelectorStub cssPseudoSelectorStub = new CssPseudoSelectorStub(parentStub, (IStubElementType)this, psi.getName(), psi.getTextOffset(), psi.getColonPrefixLength(), psi.getColonPrefixRange());
        if (cssPseudoSelectorStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "createStub"));
        }
        return cssPseudoSelectorStub;
    }

    public void serialize(@NotNull CssPseudoSelectorStub<T> stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "serialize"));
        }
        this.serializeNameAndTextOffset(stub, stream);
        stream.writeInt(stub.getColonPrefixLength());
        TextRange colonPrefixRange = stub.getColonPrefixRange();
        stream.writeInt(colonPrefixRange.getStartOffset());
        stream.writeInt(colonPrefixRange.getEndOffset());
    }

    @NotNull
    public CssPseudoSelectorStub<T> deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "deserialize"));
        }
        Pair<StringRef, Integer> nameAndOffset = this.deserializeNameAndTextOffset(stream);
        int colonPrefixLength = stream.readInt();
        int colonPrefixStartOffset = stream.readInt();
        int colonPrefixEndOffset = stream.readInt();
        TextRange colonPrefixRange = TextRange.create((int)colonPrefixStartOffset, (int)colonPrefixEndOffset);
        CssPseudoSelectorStub cssPseudoSelectorStub = new CssPseudoSelectorStub(parentStub, (IStubElementType)this, (StringRef)nameAndOffset.first, (int)((Integer)nameAndOffset.second), colonPrefixLength, colonPrefixRange);
        if (cssPseudoSelectorStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssPseudoSelectorStubElementType", "deserialize"));
        }
        return cssPseudoSelectorStub;
    }
}

