/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs.base;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CssStubElementType<StubT extends StubElement<PsiT>, PsiT extends CssElement>
extends IStubElementType<StubT, PsiT> {
    private final String myExternalId;

    public CssStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "<init>"));
        }
        this(debugName, (Language)CSSLanguage.INSTANCE);
    }

    public CssStubElementType(@NotNull @NonNls String debugName, @NotNull Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "<init>"));
        }
        super(debugName, language);
        this.myExternalId = language.getID() + "." + super.toString();
    }

    public abstract PsiElement createElement(ASTNode var1);

    public String toString() {
        return "PsiElement(" + super.toString() + ")";
    }

    @NotNull
    public String getExternalId() {
        String string = this.myExternalId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "getExternalId"));
        }
        return string;
    }

    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/css/impl/stubs/base/CssStubElementType", "indexStub"));
        }
    }
}

