/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssConstants;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorAdjustmentUtils;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiColorUtil {
    private static final Pattern STARTS_WITH_MS_GRADIENT_FUNCTION = Pattern.compile("\\s*progid\\s*:\\s*DXImageTransform\\s*\\.\\s*Microsoft\\s*\\.\\s*gradient.*", 34);

    @Nullable
    public static Color getColorInClassicCss(@NotNull PsiElement element) {
        ASTNode elementNode;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInClassicCss"));
        }
        PsiElement firstChild = element.getFirstChild();
        if (element instanceof CssTerm && firstChild instanceof CssFunction) {
            element = firstChild;
        }
        if ((elementNode = element.getNode()) != null && CssElementTypes.CSS_FUNCTION == elementNode.getElementType()) {
            if (elementNode instanceof CssFunction) {
                CssFunction cssFunction = (CssFunction)elementNode;
                PsiElement functionNameIdentifier = cssFunction.getNameIdentifier();
                if (functionNameIdentifier == null) {
                    return null;
                }
                ColorDeclarationType colorDeclarationType = ColorDeclarationType.fromColorTerm(functionNameIdentifier);
                CssTermList termList = (CssTermList)PsiTreeUtil.getChildOfType((PsiElement)element, CssTermList.class);
                if (termList != null) {
                    if (colorDeclarationType == ColorDeclarationType.RGB || colorDeclarationType == ColorDeclarationType.RGBA) {
                        return CssPsiColorUtil.getColorInRGBsFunctions((PsiElement)termList);
                    }
                    if (colorDeclarationType == ColorDeclarationType.HSL || colorDeclarationType == ColorDeclarationType.HSLA) {
                        return CssPsiColorUtil.getColorInHSLsFunctions((PsiElement)termList);
                    }
                    if (colorDeclarationType == ColorDeclarationType.GRAY) {
                        return CssPsiColorUtil.getColorInGrayFunction((PsiElement)termList);
                    }
                    if (colorDeclarationType == ColorDeclarationType.HWB) {
                        return CssPsiColorUtil.getColorInHwbFunction((PsiElement)termList);
                    }
                    if (colorDeclarationType == ColorDeclarationType.COLOR) {
                        return CssPsiColorUtil.getColorInColorFunction(termList);
                    }
                }
            }
        } else {
            return CssPsiColorUtil.getColorInTerm(element);
        }
        return null;
    }

    @Nullable
    private static Color getColorInTerm(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInTerm"));
        }
        String elementText = element.getText();
        try {
            String colorHex = null;
            String alphaHex = null;
            if (elementText.length() == 9 && elementText.charAt(0) == '#') {
                if (CssPsiColorUtil.isIeSpecific8DigitColor(element)) {
                    colorHex = elementText.substring(3);
                    alphaHex = elementText.substring(1, 3);
                } else {
                    colorHex = elementText.substring(1, 7);
                    alphaHex = elementText.substring(7);
                }
            } else if (elementText.length() == 5 && elementText.charAt(0) == '#') {
                colorHex = elementText.substring(1, 4);
                alphaHex = elementText.substring(4) + elementText.substring(4);
            }
            Color baseColor = ColorUtil.fromHex(colorHex);
            int alpha = Integer.decode("0x" + alphaHex);
            return ColorUtil.toAlpha((Color)baseColor, (int)alpha);
        }
        catch (Exception exception) {
            return ColorMap.getColor((String)elementText);
        }
    }

    private static boolean isIeSpecific8DigitColor(PsiElement element) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        if (function == null) {
            return false;
        }
        CssTermList termList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)function, CssTermList.class);
        if (termList == null) {
            return false;
        }
        return STARTS_WITH_MS_GRADIENT_FUNCTION.matcher(termList.getText()).find();
    }

    @Nullable
    private static Color getColorInRGBsFunctions(@NotNull PsiElement termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInRGBsFunctions"));
        }
        String[] terms = termList.getText().split(",");
        if (terms.length != 3 && terms.length != 4) {
            return null;
        }
        double opacity = 1.0;
        if (terms.length == 4 && (opacity = CssPsiColorUtil.getProportionValue(terms[3])) == -1.0) {
            return null;
        }
        if (StringUtil.endsWithChar((CharSequence)terms[0].trim(), (char)'%')) {
            double r = CssPsiColorUtil.getPercentageValue(terms[0]);
            if (r == -1.0) {
                return null;
            }
            double g = CssPsiColorUtil.getPercentageValue(terms[1]);
            if (g == -1.0) {
                return null;
            }
            double b = CssPsiColorUtil.getPercentageValue(terms[2]);
            if (b == -1.0) {
                return null;
            }
            return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (double)opacity);
        }
        int r = StringUtil.parseInt((String)terms[0].trim(), (int)-1);
        if (r == -1) {
            return null;
        }
        int g = StringUtil.parseInt((String)terms[1].trim(), (int)-1);
        if (g == -1) {
            return null;
        }
        int b = StringUtil.parseInt((String)terms[2].trim(), (int)-1);
        if (b == -1) {
            return null;
        }
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (double)opacity);
    }

    @Nullable
    private static Color getColorInHSLsFunctions(@NotNull PsiElement termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInHSLsFunctions"));
        }
        String[] terms = termList.getText().split(",");
        if (terms.length != 3 && terms.length != 4) {
            return null;
        }
        double hue = CssPsiColorUtil.getHueValue(terms[0]);
        if (hue == -1.0) {
            return null;
        }
        double saturation = CssPsiColorUtil.getPercentageValue(terms[1]);
        if (saturation == -1.0) {
            return null;
        }
        double lightness = CssPsiColorUtil.getPercentageValue(terms[2]);
        if (lightness == -1.0) {
            return null;
        }
        double opacity = 1.0;
        if (terms.length == 4 && (opacity = CssPsiColorUtil.getProportionValue(terms[3])) == -1.0) {
            return null;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, saturation, lightness);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)opacity);
    }

    @NotNull
    public static double[] getRgbByHsl(double hue, double saturation, double lightness) {
        double v;
        double r = lightness;
        double g = lightness;
        double b = lightness;
        double d = v = lightness <= 0.5 ? lightness * (1.0 + saturation) : lightness + saturation - lightness * saturation;
        if (v > 0.0) {
            double m = lightness + lightness - v;
            double sv = (v - m) / v;
            double _hue = hue * 6.0;
            int sextant = (int)_hue;
            double fract = _hue - (double)sextant;
            double vsf = v * sv * fract;
            double mid1 = m + vsf;
            double mid2 = v - vsf;
            switch (sextant) {
                case 0: {
                    r = v;
                    g = mid1;
                    b = m;
                    break;
                }
                case 1: {
                    r = mid2;
                    g = v;
                    b = m;
                    break;
                }
                case 2: {
                    r = m;
                    g = v;
                    b = mid1;
                    break;
                }
                case 3: {
                    r = m;
                    g = mid2;
                    b = v;
                    break;
                }
                case 4: {
                    r = mid1;
                    g = m;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = m;
                    b = mid2;
                }
            }
        }
        double[] dArray = new double[]{r, g, b};
        if (dArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getRgbByHsl"));
        }
        return dArray;
    }

    @NotNull
    public static double[] getHslByRgb(int red, int green, int blue) {
        double S;
        double var_Max;
        double var_Min;
        double var_R = (double)red / 255.0;
        double var_G = (double)green / 255.0;
        double var_B = (double)blue / 255.0;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        double del_Max = var_Max - var_Min;
        double H = 0.0;
        double L = (var_Max + var_Min) / 2.0;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.3333333333333333 + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666666666666666 + del_G - del_R;
            }
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        double[] dArray = new double[]{H, S, L};
        if (dArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getHslByRgb"));
        }
        return dArray;
    }

    @Nullable
    private static Color getColorInGrayFunction(@NotNull PsiElement termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInGrayFunction"));
        }
        String[] terms = termList.getText().split(",");
        if (terms.length != 1 && terms.length != 2) {
            return null;
        }
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = terms[i].trim();
        }
        double opacity = 1.0;
        if (terms.length == 2) {
            double d = opacity = StringUtil.endsWithChar((CharSequence)terms[1], (char)'%') ? CssPsiColorUtil.getPercentageValue(terms[1]) : CssPsiColorUtil.getProportionValue(terms[1]);
            if (opacity == -1.0) {
                return null;
            }
        }
        if (StringUtil.endsWithChar((CharSequence)terms[0], (char)'%')) {
            double gray = CssPsiColorUtil.getPercentageValue(terms[0]);
            return gray != -1.0 ? ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(gray, gray, gray), (double)opacity) : null;
        }
        int gray = StringUtil.parseInt((String)terms[0], (int)-1);
        return gray != -1 ? ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(gray, gray, gray), (double)opacity) : null;
    }

    @Nullable
    private static Color getColorInHwbFunction(@NotNull PsiElement termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInHwbFunction"));
        }
        String[] terms = termList.getText().split(",");
        if (terms.length != 3 && terms.length != 4) {
            return null;
        }
        double hue = CssPsiColorUtil.getHueValue(terms[0]);
        if (hue == -1.0) {
            return null;
        }
        double whiteness = CssPsiColorUtil.getPercentageValue(terms[1]);
        if (whiteness == -1.0) {
            return null;
        }
        double blackness = CssPsiColorUtil.getPercentageValue(terms[2]);
        if (blackness == -1.0) {
            return null;
        }
        double opacity = 1.0;
        if (terms.length == 4) {
            double d = opacity = StringUtil.endsWithChar((CharSequence)terms[3].trim(), (char)'%') ? CssPsiColorUtil.getPercentageValue(terms[3]) : CssPsiColorUtil.getProportionValue(terms[3]);
            if (opacity == -1.0) {
                return null;
            }
        }
        double[] rgb = CssPsiColorUtil.getRgbByHwb(hue, whiteness, blackness);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)opacity);
    }

    @NotNull
    public static double[] getRgbByHwb(double hue, double whiteness, double blackness) {
        double white = whiteness;
        double black = blackness;
        double whitePlusBlack = white + black;
        if (whitePlusBlack > 1.0) {
            white *= 1.0 / whitePlusBlack;
            black *= 1.0 / whitePlusBlack;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, 1.0, 0.5);
        int i = 0;
        while (i < rgb.length) {
            int n = i;
            rgb[n] = rgb[n] * (1.0 - white - black);
            int n2 = i++;
            rgb[n2] = rgb[n2] + white;
        }
        if (rgb == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getRgbByHwb"));
        }
        return rgb;
    }

    @Nullable
    private static Color getColorInColorFunction(@NotNull CssTermList termList) {
        Color baseColor;
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getColorInColorFunction"));
        }
        if (termList.getTerms().length == 0) {
            return null;
        }
        CssTerm baseColorTerm = termList.getTerms()[0];
        double hue = CssPsiColorUtil.getHueValue(baseColorTerm.getText());
        if (hue != -1.0) {
            double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, 1.0, 0.5);
            baseColor = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        } else {
            baseColor = CssPsiColorUtil.getColorInClassicCss((PsiElement)baseColorTerm);
        }
        if (baseColor == null) {
            return null;
        }
        for (int i = 1; i < termList.getTerms().length; ++i) {
            CssTerm term = termList.getTerms()[i];
            Color color = CssPsiColorAdjustmentUtils.adjustColor(baseColor, term);
            if (color == null) continue;
            baseColor = color;
        }
        return baseColor;
    }

    public static double getPercentageValue(@NotNull String term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getPercentageValue"));
        }
        int ndx = term.indexOf(37);
        if (ndx < 0) {
            return -1.0;
        }
        double value = StringUtil.parseDouble((String)term.substring(0, ndx), (double)-1.0);
        return value != -1.0 ? Math.min(Math.max(value / 100.0, 0.0), 1.0) : -1.0;
    }

    public static double getPercentageValueWithSign(@NotNull String term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getPercentageValueWithSign"));
        }
        int ndx = term.indexOf(37);
        if (ndx < 0) {
            return Double.NaN;
        }
        double value = StringUtil.parseDouble((String)term.substring(0, ndx), (double)Double.NaN);
        return value != Double.NaN ? Math.min(Math.max(value / 100.0, -1.0), 1.0) : Double.NaN;
    }

    public static double getProportionValue(@NotNull String term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getProportionValue"));
        }
        double value = StringUtil.parseDouble((String)term, (double)-1.0);
        return value != -1.0 ? Math.min(Math.max(value, 0.0), 1.0) : -1.0;
    }

    public static double getHueValue(@NotNull String term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getHueValue"));
        }
        int hue = StringUtil.parseInt((String)term.trim(), (int)-1);
        return hue != -1 ? (double)((hue % 360 + 360) % 360) / 360.0 : -1.0;
    }

    @Nullable
    public static Color getColor(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
        CssTerm term = CssPsiColorUtil.getColorTerm(element);
        if (term != null) {
            PsiElement firstChild = term.getFirstChild();
            if (firstChild != null) {
                Color color = CssPsiColorUtil.getColorInClassicCss(firstChild);
                if (color != null) {
                    return color;
                }
                String value = firstChild.getText();
                if (value != null && descriptorProvider != null) {
                    return descriptorProvider.getColorByValue(value);
                }
            }
        } else {
            Color color = CssPsiColorUtil.getColorInClassicCss(element);
            if (color != null) {
                return color;
            }
            String value = element.getText();
            if (value != null && descriptorProvider != null) {
                return descriptorProvider.getColorByValue(value);
            }
        }
        return null;
    }

    @Nullable
    public static CssTerm getColorTerm(@Nullable PsiElement element) {
        CssTerm term = null;
        if (element instanceof CssTermList) {
            PsiElement[] children = element.getChildren();
            if (children.length > 0 && children[0] instanceof CssTerm) {
                term = (CssTerm)children[0];
            }
        } else {
            term = CssUtil.getEnclosingTerm(element);
        }
        if (term == null || !term.isValid()) {
            return null;
        }
        if (CssTermTypes.COLOR == term.getTermType()) {
            return term;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
        if (descriptorProvider != null && descriptorProvider.isColorTerm(term)) {
            return term;
        }
        return null;
    }

    public static Color createColor(int r, int g, int b) {
        return new Color(Math.min(Math.max(r, 0), 255), Math.min(Math.max(g, 0), 255), Math.min(Math.max(b, 0), 255));
    }

    public static Color createColor(int r, int g, int b, int a) {
        return ColorUtil.toAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (int)Math.min(Math.max(a, 0), 255));
    }

    public static Color createColor(double r, double g, double b) {
        return new Color(Math.min(Math.max((float)r, 0.0f), 1.0f), Math.min(Math.max((float)g, 0.0f), 1.0f), Math.min(Math.max((float)b, 0.0f), 1.0f));
    }

    public static Color createColor(double r, double g, double b, int a) {
        return ColorUtil.toAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (int)Math.min(Math.max(a, 0), 255));
    }

    @NotNull
    public static String toRgbColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toRgbColor"));
        }
        String string = color.getAlpha() < 255 ? String.format("rgba(%d,%d,%d,%s)", color.getRed(), color.getGreen(), color.getBlue(), CssPsiColorUtil.getAlphaString(color)) : String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toRgbColor"));
        }
        return string;
    }

    @NotNull
    private static String getAlphaString(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getAlphaString"));
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        String string = color.getAlpha() == 0 ? "0" : decimalFormat.format((double)color.getAlpha() / 255.0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getAlphaString"));
        }
        return string;
    }

    @NotNull
    public static String toHexColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHexColor"));
        }
        StringBuilder sb = new StringBuilder("#");
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString(i == 0 ? color.getRed() : (i == 1 ? color.getGreen() : color.getBlue()));
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHexColor"));
        }
        return string;
    }

    public static boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "isColorTerm"));
        }
        if (term.getTermType() == CssTermTypes.COLOR && !CssPsiColorUtil.isInsideColorFunction((PsiElement)term)) {
            return true;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)term);
        return descriptorProvider != null && descriptorProvider.isColorTerm(term);
    }

    @Contract(value="null -> false")
    public static boolean isInsideColorFunction(@Nullable PsiElement element) {
        String functionName;
        CssFunction possibleParentFunction = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        return possibleParentFunction != null && CssConstants.FUNCTIONS_OVER_COLOR.contains((functionName = possibleParentFunction.getName()).toLowerCase(Locale.US));
    }

    @NotNull
    public static String toHslColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHslColor"));
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        long h = Math.round(360.0 * hsl[0]);
        long s = Math.round(hsl[1] * 100.0);
        long l = Math.round(hsl[2] * 100.0);
        String string = color.getAlpha() < 255 ? String.format("hsla(%d,%d%%,%d%%,%s)", h, s, l, CssPsiColorUtil.getAlphaString(color)) : String.format("hsl(%d,%d%%,%d%%)", h, s, l);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHslColor"));
        }
        return string;
    }

    public static String convertTo(@NotNull ColorDeclarationType declarationType, @NotNull Color color) {
        if (declarationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationType", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "convertTo"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "convertTo"));
        }
        switch (declarationType) {
            case RGB: 
            case RGBA: {
                return CssPsiColorUtil.toRgbColor(color);
            }
            case HSL: 
            case HSLA: {
                return CssPsiColorUtil.toHslColor(color);
            }
        }
        return color.getAlpha() < 255 ? CssPsiColorUtil.toRgbColor(color) : CssPsiColorUtil.toHexColor(color);
    }

    @NotNull
    public static String toShortHexColor(@NotNull String colorInLongNotation) {
        int shift;
        if (colorInLongNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorInLongNotation", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toShortHexColor"));
        }
        int n = shift = StringUtil.startsWithChar((CharSequence)colorInLongNotation, (char)'#') ? 1 : 0;
        if (colorInLongNotation.length() - shift == 6 && colorInLongNotation.charAt(shift) == colorInLongNotation.charAt(1 + shift) && colorInLongNotation.charAt(2 + shift) == colorInLongNotation.charAt(3 + shift) && colorInLongNotation.charAt(4 + shift) == colorInLongNotation.charAt(5 + shift)) {
            colorInLongNotation = "#" + colorInLongNotation.charAt(shift) + colorInLongNotation.charAt(2 + shift) + colorInLongNotation.charAt(4 + shift);
        }
        String string = colorInLongNotation;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toShortHexColor"));
        }
        return string;
    }

    @NotNull
    public static String normalizeHexColor(@NotNull String colorText) {
        if (colorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorText", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
        }
        if (StringUtil.startsWithChar((CharSequence)colorText, (char)'#')) {
            colorText = colorText.substring(1);
        }
        switch (colorText.length()) {
            case 0: {
                String string = colorText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 1: {
                String string = '#' + StringUtil.repeat((String)colorText, (int)6);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 2: {
                String string = '#' + StringUtil.repeat((String)colorText, (int)3);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 3: {
                String string = "#" + colorText.charAt(0) + colorText.charAt(0) + colorText.charAt(1) + colorText.charAt(1) + colorText.charAt(2) + colorText.charAt(2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 4: {
                String string = '#' + colorText + colorText.substring(0, 2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 5: {
                String string = '#' + colorText + colorText.charAt(0);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
        }
        String string = '#' + colorText.substring(0, 6);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
        }
        return string;
    }

    @NotNull
    public static String toGreyColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toGreyColor"));
        }
        String string = color.getAlpha() < 255 ? String.format("gray(%d,%s)", color.getRed(), CssPsiColorUtil.getAlphaString(color)) : String.format("gray(%d)", color.getRed());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toGreyColor"));
        }
        return string;
    }

    @NotNull
    public static String toHwbColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHwbColor"));
        }
        double[] hwb = CssPsiColorUtil.getHwbByRgb(color.getRed(), color.getGreen(), color.getBlue());
        long h = Math.round(360.0 * hwb[0]);
        long w = Math.round(hwb[1] * 100.0);
        long b = Math.round(hwb[2] * 100.0);
        String string = color.getAlpha() < 255 ? String.format("hwb(%d,%d%%,%d%%,%s)", h, w, b, CssPsiColorUtil.getAlphaString(color)) : String.format("hwb(%d,%d%%,%d%%)", h, w, b);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHwbColor"));
        }
        return string;
    }

    @NotNull
    public static double[] getHwbByRgb(int red, int green, int blue) {
        double[] hsl = CssPsiColorUtil.getHslByRgb(red, green, blue);
        double s = hsl[1];
        double l = hsl[2];
        double saturation = 2.0 * (s *= l < 0.5 ? l : 1.0 - l) / (l + s);
        double value = l + s;
        double[] dArray = new double[]{hsl[0], (1.0 - saturation) * value, 1.0 - value};
        if (dArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getHwbByRgb"));
        }
        return dArray;
    }
}

