/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CounterUserLookup
extends CssUserLookupBase {
    @NonNls
    private static final String DEFAULT_TYPE = "disc";
    @NonNls
    private static final String[] LIST_TYPES = new String[]{"disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha", "upper-alpha", "none"};

    public CounterUserLookup() {
        super(CssBundle.message((String)"counter.in.lookup", (Object[])new Object[0]));
    }

    @Override
    protected void addAdditionalVariablesBefore(Template template) {
        template.addTextSegment("counter(");
    }

    @Override
    protected void addAdditionalVariablesAfter(Template template) {
        Expression expression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(CounterUserLookup.DEFAULT_TYPE);
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
                for (String list_type : LIST_TYPES) {
                    result.add(LookupElementBuilder.create((String)list_type));
                }
                return result.toArray(new LookupElement[result.size()]);
            }
        };
        template.addTextSegment(",");
        template.addVariable("list-type", expression, expression, true);
        template.addTextSegment(")");
    }

    @Override
    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/completion/CounterUserLookup", "isValidValue"));
        }
        return true;
    }

    @Override
    public int hashCode() {
        return CounterUserLookup.class.hashCode();
    }
}

