/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssCustomMixin;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.impl.stubs.index.CssCustomMixinIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCustomPropertySetCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final int myBasePriority;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;

    public CssCustomPropertySetCompletionProvider(int basePriority, @Nullable InsertHandler<LookupElement> insertHandler) {
        this.myBasePriority = basePriority;
        this.myInsertHandler = insertHandler;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/CssCustomPropertySetCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssCustomPropertySetCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        for (String name : StubIndex.getInstance().getAllKeys(CssCustomMixinIndex.KEY, project)) {
            Collection mixins = StubIndex.getElements(CssCustomMixinIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssCustomMixin.class);
            for (CssCustomMixin mixin : mixins) {
                result.addElement(CssCompletionUtil.lookupForCustomProperty("--" + name, (CssNamedElement)mixin, parameters.getOriginalFile(), this.myBasePriority, this.myInsertHandler));
            }
        }
    }
}

