/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyNameInsertHandler;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PropertyNamesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final InsertHandler<LookupElement> PROPERTY_NAME_INSERT_HANDLER = new CssPropertyNameInsertHandler(":", true);

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "addCompletions"));
        }
        this.addPropertiesToCompletion(result, parameters, CssDescriptorsUtil.getAllPropertyDescriptors((PsiElement)parameters.getPosition()));
    }

    protected void addPropertiesToCompletion(@NotNull CompletionResultSet result, @NotNull CompletionParameters parameters, @NotNull Collection<? extends CssPropertyDescriptor> propertyDescriptors) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "addPropertiesToCompletion"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "addPropertiesToCompletion"));
        }
        if (propertyDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptors", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "addPropertiesToCompletion"));
        }
        result.addAllElements(CssCompletionUtil.lookupItemsForDescriptors(propertyDescriptors, this.getInsertHandler(), 10));
    }

    @NotNull
    protected InsertHandler<LookupElement> getInsertHandler() {
        InsertHandler<LookupElement> insertHandler = PROPERTY_NAME_INSERT_HANDLER;
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/provider/PropertyNamesCompletionProvider", "getInsertHandler"));
        }
        return insertHandler;
    }
}

