/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorProviderImpl
extends CssElementDescriptorProvider {
    private static final String[] KEYFRAMES_SELECTORS = new String[]{"to", "from"};
    private Reference<Set<String>> myHtmlTags;
    private long myCacheStamp = 0L;

    public boolean isMyContext(@Nullable PsiElement context) {
        return true;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getPropertyDescriptor"));
        }
        return CssElementDescriptorFactory.getDescriptor(propertyName);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPseudoSelectorDescriptors"));
        }
        Collection<CssPseudoSelectorDescriptor> collection = CssElementDescriptorProviderImpl.factory().findPseudoSelector(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getNamedValueDescriptors"));
        }
        Collection<CssValueDescriptor> collection = CssElementDescriptorProviderImpl.factory().findNamedValue(name, parent);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getNamedValueDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
        }
        CssElementDescriptorFactory2 descriptorFactory = CssElementDescriptorProviderImpl.factory();
        Collection<CssPropertyDescriptor> result = descriptorFactory.findProperty(propertyName);
        if (!result.isEmpty()) {
            Collection<CssPropertyDescriptor> collection = result;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
            }
            return collection;
        }
        if (propertyName.length() > 1 && CssUtil.isHackPropertyName(propertyName)) {
            Collection<CssPropertyDescriptor> collection = descriptorFactory.findProperty(propertyName.substring(1));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        Collection propertyDescriptors;
        CssDeclaration declaration;
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
        }
        CssFunction function = (CssFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssFunction.class});
        if (functionName.equalsIgnoreCase("toggle") && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class)) != null && !(propertyDescriptors = declaration.getDescriptors()).isEmpty()) {
            List list = ContainerUtil.map((Collection)propertyDescriptors, (Function)new Function<CssPropertyDescriptor, CssFunctionDescriptor>(){

                public CssFunctionDescriptor fun(CssPropertyDescriptor descriptor) {
                    return CssElementDescriptorProviderImpl.factory().createToggleFunctionDescriptorFromPropertyDescriptor(descriptor);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
            }
            return list;
        }
        if (functionName.equalsIgnoreCase("var") && function != null) {
            HashSet result = ContainerUtil.newHashSet();
            CssDescriptorOwner descriptorOwner = (CssDescriptorOwner)PsiTreeUtil.getParentOfType((PsiElement)context, CssDescriptorOwner.class);
            final PsiElement functionTerm = function.getParent();
            if (descriptorOwner != null && descriptorOwner instanceof CssValueOwner && functionTerm instanceof CssTerm) {
                final CssTermList value = ((CssValueOwner)descriptorOwner).getValue();
                Collection descriptors = descriptorOwner.getDescriptors();
                if (value != null && !descriptors.isEmpty()) {
                    result.addAll(ContainerUtil.mapNotNull((Collection)descriptors, (Function)new Function<CssElementDescriptor, CssFunctionDescriptor>(){

                        public CssFunctionDescriptor fun(CssElementDescriptor descriptor) {
                            CssValueDescriptor valueDescriptor;
                            CssValueMatchData valueMatchData;
                            CssValueDescriptor descriptorForFunction;
                            if (descriptor instanceof CssValueOwnerDescriptor && (descriptorForFunction = (valueMatchData = value.matchWithValueDescriptor(valueDescriptor = ((CssValueOwnerDescriptor)descriptor).getValueDescriptor())).findDeepestDescriptorForElement(functionTerm)) != null) {
                                CssValueDescriptor parentDescriptor = descriptorForFunction.getParent();
                                while (parentDescriptor instanceof CssGroupValue && ((CssGroupValue)parentDescriptor).getType() == CssGroupValue.Type.OR) {
                                    descriptorForFunction = parentDescriptor;
                                    parentDescriptor = descriptorForFunction.getParent();
                                }
                                return CssElementDescriptorProviderImpl.factory().createVarFunctionDescriptorFromPropertyDescriptors(descriptorForFunction);
                            }
                            return null;
                        }
                    }));
                }
            }
            if (result.isEmpty()) {
                CssAnyValue valueDescriptor = CssElementDescriptorProviderImpl.factory().createAnyValueDescriptor(1, 1, null);
                result.add(CssElementDescriptorProviderImpl.factory().createVarFunctionDescriptorFromPropertyDescriptors((CssValueDescriptor)valueDescriptor));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
            }
            return hashSet;
        }
        Collection<CssFunctionDescriptor> collection = CssElementDescriptorProviderImpl.factory().findFunction(functionName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
        if (mediaFeatureName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeatureName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findMediaFeatureDescriptors"));
        }
        Collection<CssMediaFeatureDescriptor> collection = CssElementDescriptorProviderImpl.factory().findMediaFeature(mediaFeatureName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findMediaFeatureDescriptors"));
        }
        return collection;
    }

    private static CssElementDescriptorFactory2 factory() {
        return CssElementDescriptorFactory2.getInstance();
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "isPossibleSelector"));
        }
        return super.isPossibleSelector(selector.toLowerCase(Locale.US), context);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getPseudoSelectors().values(), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getProperties().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getMediaFeatures().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllMediaFeatureDescriptors"));
        }
        return collection;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getSimpleSelectors"));
        }
        if (CssUtil.isInsideKeyframes(context)) {
            if (KEYFRAMES_SELECTORS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getSimpleSelectors"));
            }
            return KEYFRAMES_SELECTORS;
        }
        if (CssUtil.isInsideFontFace(context) || CssUtil.isInsidePageRuleset(context)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getSimpleSelectors"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = this.getHtmlTags(context);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getSimpleSelectors"));
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getDeclarationsForSimpleSelector"));
        }
        PsiElement[] psiElementArray = new PsiElement[]{selector};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getDeclarationsForSimpleSelector"));
        }
        return psiElementArray;
    }

    public boolean providesClassicCss() {
        return true;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        HtmlCssClassOrIdReference htmlCssClassOrIdReference = new HtmlCssClassOrIdReference(element, start, end, caseSensitive, true);
        if (htmlCssClassOrIdReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getStyleReference"));
        }
        return htmlCssClassOrIdReference;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = new CssValueValidatorImpl(this);
        if (cssValueValidatorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getValueValidator"));
        }
        return cssValueValidatorImpl;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        if (context == null) {
            return CssContextType.ANY;
        }
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)context, CssAtRule.class);
        if (atRule != null) {
            CssContextType atRuleType = atRule.getType();
            if (atRuleType == CssContextType.MEDIA || atRuleType == CssContextType.SUPPORTS || atRuleType == CssContextType.KEYFRAMES) {
                CssContextType parentContextType = this.getCssContextType((PsiElement)atRule);
                return parentContextType != CssContextType.NONE ? parentContextType : CssContextType.NONAME;
            }
            return atRuleType;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, CssRuleset.class);
        if (ruleset != null) {
            return CssContextType.NONAME;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        if (attribute != null && "style".equalsIgnoreCase(attribute.getName())) {
            return CssContextType.NONAME;
        }
        return CssContextType.NONE;
    }

    public boolean shouldAskOtherProviders(@Nullable PsiElement context) {
        return false;
    }

    @NotNull
    private String[] getHtmlTags(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getHtmlTags"));
        }
        HashSet tags = ContainerUtil.newHashSet();
        for (XmlElementDescriptor descriptor : HtmlUtil.getCustomTagDescriptors((PsiElement)context)) {
            tags.add(descriptor.getName());
        }
        Set cachedTags = (Set)SoftReference.dereference(this.myHtmlTags);
        ExternalResourceManager externalResourceManager = ExternalResourceManager.getInstance();
        if (cachedTags == null || externalResourceManager.getModificationCount() != this.myCacheStamp) {
            XmlNSDescriptor nsDescriptor;
            cachedTags = ContainerUtil.newHashSet();
            XmlTag htmlTag = XmlElementFactory.getInstance((Project)context.getProject()).createHTMLTagFromText("<div></div>");
            XmlElementDescriptor htmlTagDescriptor = htmlTag.getDescriptor();
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = htmlTagDescriptor != null ? htmlTagDescriptor.getNSDescriptor() : null;
            if (nsDescriptor != null) {
                XmlDocument document = ((XmlFile)htmlTag.getContainingFile()).getDocument();
                for (XmlElementDescriptor descriptor : nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor instanceof HtmlUtil.CustomXmlTagDescriptor) continue;
                    cachedTags.add(descriptor.getName());
                }
                this.myCacheStamp = externalResourceManager.getModificationCount();
                this.myHtmlTags = new SoftReference((Object)cachedTags);
            }
        }
        tags.addAll(cachedTags);
        String[] stringArray = ArrayUtil.toStringArray((Collection)tags);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getHtmlTags"));
        }
        return stringArray;
    }
}

