/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssConvertColorToRgbInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.convert.color.to.rgb", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public String getShortName() {
        if ("CssConvertColorToRgbInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection", "getShortName"));
        }
        return "CssConvertColorToRgbInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType() && !CssConvertColorToRgbInspection.isColorFunction((PsiElement)_term)) {
                    holder.registerProblem((PsiElement)_term, CssBundle.message((String)"css.convert.color.value.to.rgb", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ConvertToRGBFix()});
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    protected static boolean isColorFunction(PsiElement element) {
        if (element instanceof CssTerm && CssTermTypes.COLOR == ((CssTerm)element).getTermType()) {
            ColorDeclarationType type = ColorDeclarationType.fromColorTerm(element);
            return type == ColorDeclarationType.RGB || type == ColorDeclarationType.RGBA;
        }
        return false;
    }

    private static class ConvertToRGBFix
    implements LocalQuickFix {
        private ConvertToRGBFix() {
        }

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.convert.color.value.to.rgb", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.convert.color.to.rgb.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof CssTerm)) {
                return;
            }
            final CssTerm term = (CssTerm)element;
            PsiFile psiFile = term.getContainingFile();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix$1", "run"));
                    }
                    Color color = CssPsiColorUtil.getColor((PsiElement)term);
                    if (color != null) {
                        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)term);
                        term.replace((PsiElement)CssElementFactory.getInstance((Project)project).createTerm(CssPsiColorUtil.toRgbColor(color), language));
                    }
                }
            }.execute();
        }
    }
}

