/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.RemoveElementAction;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssNegativeValueInspection
extends CssBaseInspection {
    @NonNls
    private static final String MARGIN_PROPERTY_NAME = "margin";
    @NonNls
    private static final String PADDING_PROPERTY_NAME = "padding";
    @NonNls
    private static final String LETTER_SPACING_PROPERTY_NAME = "letter-spacing";
    @NonNls
    private static final String WORD_SPACING_PROPERTY_NAME = "word-spacing";
    @NonNls
    private static final String TEXT_INDENT_PROPERTY_NAME = "text-indent";
    @NonNls
    private static final String TOP_PROPERTY_NAME = "top";
    @NonNls
    private static final String RIGHT_PROPERTY_NAME = "right";
    @NonNls
    private static final String BOTTOM_PROPERTY_NAME = "bottom";
    @NonNls
    private static final String LEFT_PROPERTY_NAME = "left";
    @NonNls
    private static final String BACKGROUND_POSITION_PROPERTY_NAME = "background-position";
    @NonNls
    private static final String BACKGROUND_PROPERTY_NAME = "background";
    @NonNls
    private static final String VERTICAL_ALIGN = "vertical-align";
    @NonNls
    private static final String BOX_SHADOW_PROPERTY_NAME = "box-shadow";
    @NonNls
    private static final String Z_INDEX = "z-index";
    @NonNls
    private static final String OUTLINE_OFFSET_PROPERTY_NAME = "outline-offset";
    @NonNls
    private static final String TEXT_SHADOW_PROPERTY_NAME = "text-shadow";
    @NonNls
    private static final String COUNTER_INCREMENT_PROPERTY_NAME = "counter-increment";
    @NonNls
    private static final String COUNTER_RESET_PROPERTY_NAME = "counter-reset";
    @NonNls
    private static final String COLOR_PROPERTY_NAME = "color";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.negative.value", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "getDisplayName"));
        }
        return string;
    }

    private static boolean isNegativeAllowed(@NotNull String propertyName, PsiElement element) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "isNegativeAllowed"));
        }
        if (BOX_SHADOW_PROPERTY_NAME.equals(propertyName)) {
            CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class);
            if (term == null) {
                return false;
            }
            PsiElement parent = term.getParent();
            if (!(parent instanceof CssTermList)) {
                return false;
            }
            CssTermList termList = (CssTermList)parent;
            int index = 0;
            for (PsiElement child = termList.getFirstChild(); child != null && child != term; child = child.getNextSibling()) {
                CssTermType termType;
                if (!(child instanceof CssTerm) || (termType = ((CssTerm)child).getTermType()) != CssTermTypes.NUMBER && termType != CssTermTypes.NEGATIVE_NUMBER && termType != CssTermTypes.LENGTH && termType != CssTermTypes.NEGATIVE_LENGTH) continue;
                ++index;
            }
            return index != 2;
        }
        return propertyName.contains(MARGIN_PROPERTY_NAME) || propertyName.contains(PADDING_PROPERTY_NAME) || LETTER_SPACING_PROPERTY_NAME.equals(propertyName) || WORD_SPACING_PROPERTY_NAME.equals(propertyName) || TEXT_INDENT_PROPERTY_NAME.equals(propertyName) || TOP_PROPERTY_NAME.equals(propertyName) || RIGHT_PROPERTY_NAME.equals(propertyName) || BOTTOM_PROPERTY_NAME.equals(propertyName) || BACKGROUND_POSITION_PROPERTY_NAME.equals(propertyName) || BACKGROUND_PROPERTY_NAME.equals(propertyName) || LEFT_PROPERTY_NAME.equals(propertyName) || VERTICAL_ALIGN.equals(propertyName) || Z_INDEX.equals(propertyName) || OUTLINE_OFFSET_PROPERTY_NAME.equals(propertyName) || TEXT_SHADOW_PROPERTY_NAME.equals(propertyName) || COUNTER_INCREMENT_PROPERTY_NAME.equals(propertyName) || COUNTER_RESET_PROPERTY_NAME.equals(propertyName) || COLOR_PROPERTY_NAME.equals(propertyName);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssString(CssString _string) {
                CssNegativeValueInspection.processElement((PsiElement)_string, holder);
            }

            public void visitElement(PsiElement element) {
                if (element instanceof CssTokenImpl) {
                    CssNegativeValueInspection.processElement(element, holder);
                }
                super.visitElement(element);
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static boolean isUnknownProperty(@NotNull PsiElement element) {
        PsiReference[] references;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "isUnknownProperty"));
        }
        for (PsiReference reference : references = element.getFirstChild().getReferences()) {
            PsiElement psiElement = reference.resolve();
            if (psiElement != null) continue;
            return true;
        }
        return false;
    }

    private static void processElement(@NotNull PsiElement element, @NotNull ProblemsHolder holder) {
        CssDescriptorOwner parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "processElement"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssNegativeValueInspection", "processElement"));
        }
        ASTNode node = element.getNode();
        assert (node != null);
        if (CssElementTypes.CSS_MINUS == node.getElementType() && (parent = (CssDescriptorOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class, CssFunction.class})) instanceof CssDeclaration && !((CssDeclaration)parent).isCustomProperty()) {
            CssDeclaration declaration = (CssDeclaration)parent;
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)declaration);
            if (descriptorProvider == null || !descriptorProvider.providesClassicCss()) {
                return;
            }
            String propertyName = declaration.getPropertyName();
            CssPropertyDescriptor propertyDescriptor = descriptorProvider.getPropertyDescriptor(propertyName, (PsiElement)declaration);
            if (propertyDescriptor != null) {
                propertyName = propertyDescriptor.toCanonicalName(propertyName);
            }
            if (!(CssNegativeValueInspection.isNegativeAllowed(propertyName, element) || CssNegativeValueInspection.isUnknownProperty((PsiElement)declaration) || CssPropertyUtil.isVendorSpecificElement(propertyName))) {
                PsiElement sibling = element.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling = sibling.getNextSibling();
                }
                if (sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM) {
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor(element, sibling, CssBundle.message((String)"css.inspections.negative.value.text", (Object[])new Object[]{propertyName}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, holder.isOnTheFly(), new LocalQuickFix[]{new RemoveElementAction(element.getText())});
                    holder.registerProblem(descriptor);
                }
            }
        }
    }
}

