/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CssUnitlessNumberInspection
extends CssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unitless.number", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/bugs/CssUnitlessNumberInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/bugs/CssUnitlessNumberInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                CssPropertyDescriptor descriptor = cssDeclaration.getDescriptor();
                if (descriptor == null || descriptor.allowsIntegerWithoutSuffix()) {
                    return;
                }
                CssTermList termList = cssDeclaration.getValue();
                if (termList == null) {
                    return;
                }
                boolean lineHeight = false;
                boolean fontProperty = "font".equalsIgnoreCase(descriptor.getPropertyName());
                for (PsiElement t : termList.getChildren()) {
                    IElementType iElementType;
                    PsiElement firstTermElement = t.getFirstChild();
                    if (fontProperty && t instanceof LeafElement && CssElementTypes.CSS_SLASH == ((LeafElement)t).getElementType()) {
                        lineHeight = true;
                    }
                    if (firstTermElement == null) continue;
                    PsiElement child = firstTermElement.getFirstChild();
                    boolean foundNumberTerm = false;
                    if (child instanceof CssTokenImpl && (iElementType = ((CssTokenImpl)child).getElementType()) == CssElementTypes.CSS_NUMBER) {
                        foundNumberTerm = true;
                    }
                    if (!foundNumberTerm) continue;
                    boolean zeroValue = "0".equals(child.getText());
                    PsiElement nextSibling = child.getNextSibling();
                    if (!zeroValue && nextSibling == null && !lineHeight) {
                        holder.registerProblem(firstTermElement, CssBundle.message((String)"css.inspections.unitless.number.message", (Object[])new Object[]{child.getText()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{CssFixFactory.getInstance().insertUnitQualifier(cssDeclaration)});
                    }
                    lineHeight = false;
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/bugs/CssUnitlessNumberInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

