/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementFactory;
import org.jetbrains.annotations.NotNull;

public class CssAddPrefixQuickFix
extends LocalQuickFixBase {
    @NotNull
    private final String myPrefix;
    @NotNull
    private final Class<? extends CssAtRule> myClass;

    public CssAddPrefixQuickFix(@NotNull String message, @NotNull String prefix, @NotNull Class<? extends CssAtRule> elementClass) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix", "<init>"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix", "<init>"));
        }
        super(message);
        this.myPrefix = prefix;
        this.myClass = elementClass;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix", "applyFix"));
        }
        PsiElement startElement = descriptor.getStartElement();
        if (this.myClass.isInstance(startElement)) {
            TextRange textRange = descriptor.getTextRangeInElement();
            String text = textRange.substring(startElement.getText());
            for (int i = 0; i < this.myPrefix.length(); ++i) {
                if (StringUtil.startsWith((CharSequence)text, (CharSequence)this.myPrefix.substring(0, i + 1))) continue;
                text = this.myPrefix + text.substring(i);
                break;
            }
            String newText = textRange.replace(startElement.getText(), text);
            startElement.replace((PsiElement)CssElementFactory.getInstance((Project)project).createAtRule(newText, this.myClass, startElement.getLanguage()));
        }
    }
}

