/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.inspections.CssBaseInspection;
import org.jetbrains.annotations.NotNull;

public class CssInvalidAtRuleInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidAtRuleInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitAtRule(CssAtRule atRule) {
                PsiElement firstChild;
                if (atRule.getType() == CssContextType.UNKNOWN && (firstChild = atRule.getFirstChild()) != null) {
                    holder.registerProblem(firstChild, CssBundle.message((String)"css.inspections.unknown.at.rule", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidAtRuleInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

