/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class CssInvalidCharsetRuleInspection
extends CssBaseInspection {
    private static final LocalQuickFix REMOVE_MISPLACED_CHARSET = new LocalQuickFixBase(CssBundle.message((String)"css.inspections.remove.charset.fix", (Object[])new Object[0])){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element != null && element instanceof CssCharset) {
                new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1$1", "run"));
                        }
                        element.delete();
                    }
                }.execute();
            }
        }
    };
    private static final LocalQuickFix CHANGE_QUOTES_FIX = new LocalQuickFixBase(CssBundle.message((String)"css.intentions.replace.quotes", (Object[])new Object[0])){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String text;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element != null && element instanceof CssString && StringUtil.isQuotedString((String)(text = element.getText())) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                final CssString newString = CssElementFactory.getInstance((Project)project).createString('\"', StringUtil.unquoteString((String)text), CssPsiUtil.getStylesheetLanguage((PsiElement)element));
                new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2$1", "run"));
                        }
                        element.replace((PsiElement)newString);
                    }
                }.execute();
            }
        }
    };
    private static final LocalQuickFix MOVE_CHARSET_AT_THE_BEGINNING_FIX = new LocalQuickFixBase(CssBundle.message((String)"css.inspections.move.charset.fix", (Object[])new Object[0])){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            CssStylesheet stylesheet;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element != null && element instanceof CssCharset && (stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class)) != null) {
                new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3$1", "run"));
                        }
                        stylesheet.addBefore(element, stylesheet.getFirstChild());
                        element.delete();
                    }
                }.execute();
            }
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssCharset(CssCharset charset) {
                PsiElement parent = charset.getParent();
                CssString valueElement = charset.getValueElement();
                if (valueElement != null && valueElement.getChildren().length > 1) {
                    return;
                }
                if (!(charset.getContainingFile() instanceof StylesheetFile)) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message((String)"css.inspections.charset.wrong.file", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{REMOVE_MISPLACED_CHARSET});
                } else if (!(parent instanceof CssStylesheet) || parent.getPrevSibling() != null || charset.getPrevSibling() != null) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message((String)"css.inspections.charset.wrong.position", (Object[])new Object[0]), new LocalQuickFix[]{MOVE_CHARSET_AT_THE_BEGINNING_FIX, REMOVE_MISPLACED_CHARSET});
                }
                if (valueElement != null) {
                    String text = valueElement.getText();
                    if (StringUtil.isQuotedString((String)text) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message((String)"css.inspections.charset.wrong.quotes", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{CHANGE_QUOTES_FIX});
                    }
                    if (!Charset.availableCharsets().containsKey(StringUtil.unquoteString((String)text))) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message((String)"css.inspections.charset.unknown.value", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

