/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidPropertyValueInspection
extends CssBaseInspection {
    private static final CssPropertyInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssPropertyInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
                Collection filteredByMediaTypeDescriptors;
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$1", "visitCssDeclaration"));
                }
                String name = declaration.getPropertyName();
                PsiElement nameIdentifier = declaration.getPropertyNameElement();
                if (StringUtil.isEmpty((String)name) || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = declaration.getDescriptors();
                Collection filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext((Collection)descriptors, (PsiElement)nameIdentifier);
                if (!filteredByContextDescriptors.isEmpty() && !(filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)(descriptors = filteredByContextDescriptors), (PsiElement)nameIdentifier)).isEmpty()) {
                    descriptors = filteredByMediaTypeDescriptors;
                }
                CssInspectionsUtil.checkDescriptorValue(descriptors, (CssValueOwner)declaration, holder, "css.inspections.property.mismatched.values", INVALID_VALUE_RANGE_PROVIDER, true, true, true);
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static class CssPropertyInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssPropertyInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueOwner", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$CssPropertyInvalidValueRangeProvider", "calculateInvalidRange"));
            }
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$CssPropertyInvalidValueRangeProvider", "calculateInvalidRange"));
            }
            if (valueOwner instanceof CssDeclaration) {
                int endOfValue;
                int startOfInvalidElements;
                TextRange range;
                CssDeclaration declaration = (CssDeclaration)valueOwner;
                TextRange declarationTextRange = declaration.getTextRange();
                int declarationStartOffset = declarationTextRange.getStartOffset();
                if (lastMatchedElement != null && !(range = TextRange.create((int)(startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset()), (int)(endOfValue = Math.max(declaration.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)))).isEmpty()) {
                    return range.shiftRight(-declarationStartOffset);
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }
    }
}

