/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractTagUtil {
    private static final String HTML_TAG_NAME = "html";
    private static final String HEAD_TAG_NAME = "head";
    private static final String BODY_TAG_NAME = "body";
    private static final String STYLE_TYPE_ATTRIBUTE = "type";
    private static final String CSS_STYLE_TYPE_ATTRIBUTE_VALUE = "text/css";

    @Nullable
    public static XmlTag addCssStyleTag(XmlDocument document, boolean styleCouldBeInsertedInRoot) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag newStyleTag = XmlElementFactory.getInstance((Project)document.getProject()).createTagFromText((CharSequence)"<style type=\"text/css\"></style>");
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        if (headTag != null) {
            return headTag.addSubTag(newStyleTag, false);
        }
        if (htmlTag != null) {
            XmlTag newHeadTag = XmlElementFactory.getInstance((Project)document.getProject()).createTagFromText((CharSequence)"<head></head>");
            newHeadTag = htmlTag.addSubTag(newHeadTag, true);
            return newHeadTag.addSubTag(newStyleTag, true);
        }
        if (styleCouldBeInsertedInRoot) {
            return (XmlTag)document.addBefore((PsiElement)newStyleTag, (PsiElement)rootTag);
        }
        return null;
    }

    @Nullable
    public static XmlTag findGenericHtmlTag(@NotNull XmlDocument document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/util/AbstractTagUtil", "findGenericHtmlTag"));
        }
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        if (rootTag == null) {
            return null;
        }
        boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
        return AbstractTagUtil.compareTagName(rootTag, HTML_TAG_NAME, caseSensitive) ? rootTag : AbstractTagUtil.findNonRootTag(rootTag, caseSensitive, HTML_TAG_NAME);
    }

    @Nullable
    public static XmlTag findGenericHeadTag(@NotNull XmlDocument document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/util/AbstractTagUtil", "findGenericHeadTag"));
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        return AbstractTagUtil.findSubTagWithName(htmlTag != null ? htmlTag : AbstractTagUtil.getRealRootTag(document), HEAD_TAG_NAME, AbstractTagUtil.isCaseSensitive(document));
    }

    @Nullable
    public static XmlTag findGenericBodyTag(@NotNull XmlDocument document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/util/AbstractTagUtil", "findGenericBodyTag"));
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
        if (htmlTag != null) {
            return AbstractTagUtil.findSubTagWithName(htmlTag, BODY_TAG_NAME, caseSensitive);
        }
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        if (rootTag != null) {
            XmlTag bodyTag = AbstractTagUtil.compareTagName(rootTag, BODY_TAG_NAME, caseSensitive) ? rootTag : AbstractTagUtil.findNonRootTag(rootTag, caseSensitive, BODY_TAG_NAME);
            return bodyTag != null ? bodyTag : AbstractTagUtil.findSubTagWithName(rootTag, BODY_TAG_NAME, caseSensitive);
        }
        return null;
    }

    public static boolean isCaseSensitive(FileType fileType) {
        return fileType == StdFileTypes.XHTML || fileType == StdFileTypes.JSPX;
    }

    @Nullable
    public static XmlTag findStyleTag(@Nullable XmlDocument document) {
        return (XmlTag)Iterables.getFirst(AbstractTagUtil.findStyleTags(document), null);
    }

    @NotNull
    public static Collection<XmlTag> findStyleTags(@Nullable XmlDocument document) {
        if (document == null) {
            List<XmlTag> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "findStyleTags"));
            }
            return list;
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        if (htmlTag != null) {
            ArrayList styleTags = Lists.newArrayList();
            styleTags.addAll(AbstractTagUtil.filterCssStyles(htmlTag.findSubTags("style")));
            XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
            if (headTag != null) {
                styleTags.addAll(AbstractTagUtil.filterCssStyles(headTag.findSubTags("style")));
            }
            ArrayList arrayList = styleTags;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "findStyleTags"));
            }
            return arrayList;
        }
        XmlTag rootTag = AbstractTagUtil.getRealRootTag(document);
        if (rootTag != null) {
            boolean caseSensitive = AbstractTagUtil.isCaseSensitive(document);
            Collection<XmlTag> result = AbstractTagUtil.findTagSiblingsWithName(rootTag, caseSensitive, "style");
            if (!result.isEmpty()) {
                Collection<XmlTag> collection = result;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "findStyleTags"));
                }
                return collection;
            }
            XmlTag[] subTags = rootTag.getSubTags();
            if (subTags.length > 0) {
                Collection<XmlTag> collection = AbstractTagUtil.findTagSiblingsWithName(subTags[0], caseSensitive, "style");
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "findStyleTags"));
                }
                return collection;
            }
        }
        List<XmlTag> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "findStyleTags"));
        }
        return list;
    }

    @Nullable
    public static XmlTag findInjectionHostTagByCssElement(@NotNull CssElement cssElement) {
        if (cssElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssElement", "com/intellij/psi/css/util/AbstractTagUtil", "findInjectionHostTagByCssElement"));
        }
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)cssElement.getProject()).getInjectionHost((PsiElement)cssElement);
        return (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(injectionHost instanceof XmlElement ? injectionHost : cssElement), (Class[])new Class[]{XmlTag.class});
    }

    @NotNull
    public static List<String> getPossibleSelectorsForTag(@Nullable XmlTag tag) {
        ArrayList<String> possibleCandidates = new ArrayList<String>(1);
        if (tag != null) {
            XmlAttribute[] attributes = tag.getAttributes();
            String tagName = tag.getName();
            boolean unqualifiedTag = tagName.indexOf(58) == -1;
            for (XmlAttribute attribute : attributes) {
                PsiReference[] references;
                XmlAttributeValue valueElement;
                String name = attribute.getName();
                String value = Strings.nullToEmpty((String)attribute.getValue());
                if (name.contains("id")) {
                    possibleCandidates.add("#" + value.trim());
                    if (!unqualifiedTag) continue;
                    possibleCandidates.add(tagName + "#" + value.trim());
                    continue;
                }
                if (!name.contains("class") || (valueElement = attribute.getValueElement()) == null) continue;
                for (PsiReference reference : references = valueElement.getReferences()) {
                    if (!(reference instanceof HtmlCssClassOrIdReference)) continue;
                    String className = reference.getRangeInElement().substring(valueElement.getText());
                    possibleCandidates.add("." + className);
                    if (!unqualifiedTag) continue;
                    possibleCandidates.add(tagName + "." + className);
                }
            }
            if (unqualifiedTag) {
                possibleCandidates.add(tagName);
            }
        }
        ArrayList<String> arrayList = possibleCandidates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "getPossibleSelectorsForTag"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<XmlTag> filterCssStyles(@NotNull XmlTag[] styleTags) {
        if (styleTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleTags", "com/intellij/psi/css/util/AbstractTagUtil", "filterCssStyles"));
        }
        List list = ContainerUtil.filter((Object[])styleTags, tag -> {
            String typeAttribute = tag.getAttributeValue(STYLE_TYPE_ATTRIBUTE);
            return typeAttribute == null || CSS_STYLE_TYPE_ATTRIBUTE_VALUE.equalsIgnoreCase(typeAttribute);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/AbstractTagUtil", "filterCssStyles"));
        }
        return list;
    }

    @Nullable
    private static XmlTag findSubTagWithName(@Nullable XmlTag parentTag, @NotNull String name, boolean caseSensitive) {
        XmlTag[] subTags;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/AbstractTagUtil", "findSubTagWithName"));
        }
        if (parentTag == null) {
            return null;
        }
        for (XmlTag subTag : subTags = parentTag.getSubTags()) {
            if (!AbstractTagUtil.compareTagName(subTag, name, caseSensitive)) continue;
            return subTag;
        }
        return null;
    }

    private static boolean compareTagName(@NotNull XmlTag tag, @NotNull @NonNls String name, boolean caseSensitive) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/util/AbstractTagUtil", "compareTagName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/AbstractTagUtil", "compareTagName"));
        }
        String tagName = tag.getLocalName();
        return caseSensitive ? name.equals(tagName) : name.equalsIgnoreCase(tagName);
    }

    @Nullable
    private static XmlTag getRealRootTag(@Nullable XmlDocument document) {
        XmlDocument realDocument = HtmlUtil.getRealXmlDocument((XmlDocument)document);
        return realDocument != null ? realDocument.getRootTag() : null;
    }

    @Nullable
    private static XmlTag findNonRootTag(@NotNull XmlTag rootTag, boolean caseSensitive, String tagName) {
        if (rootTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTag", "com/intellij/psi/css/util/AbstractTagUtil", "findNonRootTag"));
        }
        XmlTag subTagWithName = AbstractTagUtil.findSubTagWithName(rootTag, tagName, caseSensitive);
        return subTagWithName != null ? subTagWithName : (XmlTag)Iterables.getFirst(AbstractTagUtil.findTagSiblingsWithName(rootTag, caseSensitive, tagName), null);
    }

    private static Collection<XmlTag> findTagSiblingsWithName(@NotNull XmlTag xmlTag, boolean caseSensitive, String name) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/psi/css/util/AbstractTagUtil", "findTagSiblingsWithName"));
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag element = xmlTag; element != null; element = element.getNextSibling()) {
            XmlTag tag;
            if (!(element instanceof XmlTag) || !AbstractTagUtil.compareTagName(tag = element, name, caseSensitive)) continue;
            result.add(tag);
        }
        return result;
    }

    private static boolean isCaseSensitive(XmlDocument document) {
        return AbstractTagUtil.isCaseSensitive(document.getContainingFile().getFileType());
    }
}

