/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class CssSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final Tokenizer SELECTOR_SUFFIX_TOKENIZER = new Tokenizer<CssSelectorSuffix>(){

        public void tokenize(@NotNull CssSelectorSuffix selectorSuffix, TokenConsumer consumer) {
            if (selectorSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/spellchecker/CssSpellcheckingStrategy$1", "tokenize"));
            }
            TextRange range = selectorSuffix.getTextRange();
            if (range.isEmpty()) {
                return;
            }
            String text = selectorSuffix.getText().substring(1);
            consumer.consumeToken((PsiElement)selectorSuffix, text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof CssIdSelector || element instanceof CssClass) {
            Tokenizer tokenizer = SELECTOR_SUFFIX_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/CssSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/CssSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

