/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTError;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsDevice;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceManagerFactory;
import sun.java2d.UnixSurfaceManagerFactory;
import sun.java2d.xr.XRSurfaceData;
import sun.security.action.GetPropertyAction;
import sun.util.logging.PlatformLogger;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11GraphicsEnvironment");
    private static final PlatformLogger screenLog = PlatformLogger.getLogger("sun.awt.screen.X11GraphicsEnvironment");
    private static Boolean xinerState;
    private static boolean glxAvailable;
    private static boolean glxVerbose;
    private static boolean xRenderVerbose;
    private static boolean xRenderAvailable;
    private Boolean isDisplayLocal;

    private static native boolean initGLX();

    public static boolean isGLXAvailable() {
        return glxAvailable;
    }

    public static boolean isGLXVerbose() {
        return glxVerbose;
    }

    private static native boolean initXRender(boolean var0, boolean var1);

    public static boolean isXRenderAvailable() {
        return xRenderAvailable;
    }

    public static boolean isXRenderVerbose() {
        return xRenderVerbose;
    }

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static native void initDisplay(boolean var0);

    @Override
    protected native int getNumScreens();

    @Override
    protected GraphicsDevice makeScreenDevice(int n) {
        return new X11GraphicsDevice(n);
    }

    protected native int getDefaultScreenNum();

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        if (graphicsDeviceArray.length == 0) {
            throw new AWTError("no screen devices");
        }
        int n = this.getDefaultScreenNum();
        return graphicsDeviceArray[0 < n && n < graphicsDeviceArray.length ? n : 0];
    }

    @Override
    public boolean isDisplayLocal() {
        if (this.isDisplayLocal == null) {
            SunToolkit.awtLock();
            try {
                if (this.isDisplayLocal == null) {
                    this.isDisplayLocal = X11GraphicsEnvironment._isDisplayLocal();
                }
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
        return this.isDisplayLocal;
    }

    private static boolean _isDisplayLocal() {
        if (X11GraphicsEnvironment.isHeadless()) {
            return true;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (string != null) {
            return string.equals("false");
        }
        int n = X11GraphicsEnvironment.checkShmExt();
        if (n != -1) {
            return n == 1;
        }
        String string2 = X11GraphicsEnvironment.getDisplayString();
        int n2 = string2.indexOf(58);
        final String string3 = string2.substring(0, n2);
        if (n2 <= 0) {
            return true;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] inetAddressArray = null;
                Enumeration<InetAddress> enumeration = null;
                Enumeration<NetworkInterface> enumeration2 = null;
                try {
                    enumeration2 = NetworkInterface.getNetworkInterfaces();
                    inetAddressArray = InetAddress.getAllByName(string3);
                    if (inetAddressArray == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host: " + string3);
                    return Boolean.FALSE;
                }
                catch (SocketException socketException) {
                    System.err.println(socketException.getMessage());
                    return Boolean.FALSE;
                }
                while (enumeration2.hasMoreElements()) {
                    enumeration = enumeration2.nextElement().getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        for (int i = 0; i < inetAddressArray.length; ++i) {
                            if (!((Object)enumeration.nextElement()).equals(inetAddressArray[i])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public String getDefaultFontFaceName() {
        return null;
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    @Override
    public Point getCenterPoint() {
        Point point;
        if (this.runningXinerama() && (point = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return point;
        }
        return super.getCenterPoint();
    }

    @Override
    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    public boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = X11GraphicsEnvironment.pRunningXinerama();
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Running Xinerama: " + xinerState);
            }
        }
        return xinerState;
    }

    protected Rectangle getXineramaWindowBounds() {
        Point point = this.getCenterPoint();
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        Rectangle rectangle = null;
        Rectangle rectangle2 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[0]);
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            Rectangle rectangle3 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[i]);
            if (rectangle == null && rectangle3.width / 2 + rectangle3.x > point.x - 1 && rectangle3.height / 2 + rectangle3.y > point.y - 1 && rectangle3.width / 2 + rectangle3.x < point.x + 1 && rectangle3.height / 2 + rectangle3.y < point.y + 1) {
                rectangle = rectangle3;
            }
            rectangle2 = rectangle2.union(rectangle3);
        }
        if (rectangle2.width / 2 + rectangle2.x > point.x - 1 && rectangle2.height / 2 + rectangle2.y > point.y - 1 && rectangle2.width / 2 + rectangle2.x < point.x + 1 && rectangle2.height / 2 + rectangle2.y < point.y + 1) {
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Video Wall: center point is at center of all displays.");
            }
            return rectangle2;
        }
        if (rectangle != null) {
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Center point at center of a particular monitor, but not of the entire virtual display.");
            }
            return rectangle;
        }
        if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
            screenLog.finer("Center point is somewhere strange - return union of all bounds.");
        }
        return rectangle2;
    }

    @Override
    public void paletteChanged() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                if (!GraphicsEnvironment.isHeadless()) {
                    boolean bl = false;
                    String string = System.getProperty("sun.java2d.opengl");
                    if (string != null) {
                        if (string.equals("true") || string.equals("t")) {
                            bl = true;
                        } else if (string.equals("True") || string.equals("T")) {
                            bl = true;
                            glxVerbose = true;
                        }
                    }
                    boolean bl2 = true;
                    boolean bl3 = false;
                    String string2 = System.getProperty("sun.java2d.xrender");
                    if (string2 != null) {
                        if (string2.equals("false") || string2.equals("f")) {
                            bl2 = false;
                        } else if (string2.equals("True") || string2.equals("T")) {
                            bl2 = true;
                            xRenderVerbose = true;
                        }
                        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true")) {
                            bl3 = true;
                        }
                    }
                    X11GraphicsEnvironment.initDisplay(bl);
                    if (bl) {
                        glxAvailable = X11GraphicsEnvironment.initGLX();
                        if (glxVerbose && !glxAvailable) {
                            System.out.println("Could not enable OpenGL pipeline (GLX 1.3 not available)");
                        }
                    }
                    if (bl2) {
                        String string3 = System.getenv("WAYLAND_DISPLAY");
                        if (string3 == null) {
                            xRenderAvailable = X11GraphicsEnvironment.initXRender(xRenderVerbose, bl3);
                            if (xRenderVerbose && !xRenderAvailable) {
                                System.out.println("Could not enable XRender pipeline");
                            }
                        } else {
                            System.out.println("XRender is not supported on Wayland");
                        }
                    }
                    if (xRenderAvailable) {
                        XRSurfaceData.initXRSurfaceData();
                    }
                }
                return null;
            }
        });
        SurfaceManagerFactory.setInstance(new UnixSurfaceManagerFactory());
    }
}

