/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.lang.reflect.Field;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import sun.lwawt.macosx.CFRetainedResource;

class CAccessible
extends CFRetainedResource
implements Accessible {
    private static Field nativeAXResourceField = CAccessible.getNativeAXResourceField();
    private Accessible accessible;

    static Field getNativeAXResourceField() {
        try {
            Field field = AccessibleContext.class.getDeclaredField("nativeAXResource");
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CAccessible getCAccessible(Accessible accessible) {
        if (accessible == null) {
            return null;
        }
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        try {
            CAccessible cAccessible = (CAccessible)nativeAXResourceField.get(accessibleContext);
            if (cAccessible != null) {
                return cAccessible;
            }
            CAccessible cAccessible2 = new CAccessible(accessible);
            nativeAXResourceField.set(accessibleContext, cAccessible2);
            return cAccessible2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static native void unregisterFromCocoaAXSystem(long var0);

    private static native void valueChanged(long var0);

    private static native void selectionChanged(long var0);

    private CAccessible(Accessible accessible) {
        super(0L, true);
        if (accessible == null) {
            throw new NullPointerException();
        }
        this.accessible = accessible;
        if (accessible instanceof Component) {
            this.addNotificationListeners((Component)((Object)accessible));
        }
    }

    @Override
    protected synchronized void dispose() {
        if (this.ptr != 0L) {
            CAccessible.unregisterFromCocoaAXSystem(this.ptr);
        }
        super.dispose();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessible != null ? this.accessible.getAccessibleContext() : null;
    }

    public void addNotificationListeners(Component component) {
        JComponent jComponent;
        if (component instanceof JTextComponent) {
            jComponent = (JTextComponent)component;
            AXTextChangeNotifier aXTextChangeNotifier = new AXTextChangeNotifier();
            ((JTextComponent)jComponent).getDocument().addDocumentListener(aXTextChangeNotifier);
            ((JTextComponent)jComponent).addCaretListener(aXTextChangeNotifier);
        }
        if (component instanceof JProgressBar) {
            jComponent = (JProgressBar)component;
            ((JProgressBar)jComponent).addChangeListener(new AXProgressChangeNotifier());
        } else if (component instanceof JSlider) {
            jComponent = (JSlider)component;
            ((JSlider)jComponent).addChangeListener(new AXProgressChangeNotifier());
        }
    }

    static Accessible getSwingAccessible(Accessible accessible) {
        return accessible instanceof CAccessible ? ((CAccessible)accessible).accessible : accessible;
    }

    private class AXProgressChangeNotifier
    implements ChangeListener {
        private AXProgressChangeNotifier() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }
    }

    private class AXTextChangeNotifier
    implements DocumentListener,
    CaretListener {
        private AXTextChangeNotifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.selectionChanged(CAccessible.this.ptr);
            }
        }
    }
}

