/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Toolkit;
import java.security.AccessController;
import java.util.Locale;
import sun.awt.SunToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;
import sun.util.logging.PlatformLogger;

final class CPlatformResponder {
    private static final PlatformLogger keyboardLog = PlatformLogger.getLogger("sun.lwawt.macosx.CPlatformResponder");
    private final PlatformEventNotifier eventNotifier;
    private final boolean isNpapiCallback;
    private int lastKeyPressCode = 0;
    private final DeltaAccumulator deltaAccumulatorX = new DeltaAccumulator();
    private final DeltaAccumulator deltaAccumulatorY = new DeltaAccumulator();
    private boolean momentumStarted;
    private int momentumX;
    private int momentumY;
    private int momentumModifiers;
    private int lastDraggedAbsoluteX;
    private int lastDraggedAbsoluteY;
    private int lastDraggedRelativeX;
    private int lastDraggedRelativeY;
    private static final boolean useOldKeyEventProcessing = AccessController.doPrivileged(() -> "true".equals(System.getProperty("com.jetbrains.use.old.keyevent.processing")));

    CPlatformResponder(PlatformEventNotifier platformEventNotifier, boolean bl) {
        this.eventNotifier = platformEventNotifier;
        this.isNpapiCallback = bl;
    }

    void handleMouseEvent(PlatformWindow platformWindow, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl;
        SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
        if (n3 > 2 && !sunToolkit.areExtraMouseButtonsEnabled() || n3 > sunToolkit.getNumberOfButtons() - 1) {
            return;
        }
        int n9 = this.isNpapiCallback ? NSEvent.npToJavaEventType(n) : NSEvent.nsToJavaEventType(n);
        boolean bl2 = bl = n9 == 506;
        if (bl && this.lastDraggedAbsoluteX == n7 && this.lastDraggedRelativeX == n5 && this.lastDraggedAbsoluteY == n8 && this.lastDraggedRelativeY == n6) {
            return;
        }
        if (bl || n9 == 501) {
            this.lastDraggedAbsoluteX = n7;
            this.lastDraggedAbsoluteY = n8;
            this.lastDraggedRelativeX = n5;
            this.lastDraggedRelativeY = n6;
        }
        int n10 = 0;
        int n11 = 0;
        if (n9 != 503 && n9 != 504 && n9 != 505) {
            n10 = NSEvent.nsToJavaButton(n3);
            n11 = n4;
        }
        int n12 = NSEvent.nsToJavaMouseModifiers(n3, n2);
        boolean bl3 = NSEvent.isPopupTrigger(n12);
        this.eventNotifier.notifyMouseEvent(platformWindow, n9, System.currentTimeMillis(), n10, n5, n6, n7, n8, n12, n11, bl3, null);
    }

    void handleScrollEvent(int n, int n2, int n3, double d, double d2, int n4) {
        int n5;
        int n6 = NSEvent.nsToJavaMouseModifiers(2, n3);
        if (n4 > 1) {
            if (n4 == 2) {
                this.momentumStarted = false;
            } else if (n4 == 4) {
                this.momentumStarted = true;
                this.momentumX = n;
                this.momentumY = n2;
                this.momentumModifiers = n6;
            } else if (this.momentumStarted) {
                n = this.momentumX;
                n2 = this.momentumY;
                n6 = this.momentumModifiers;
            }
        }
        boolean bl = (n6 & 0x40) != 0;
        int n7 = this.deltaAccumulatorX.getRoundedDelta(d, n4);
        int n8 = this.deltaAccumulatorY.getRoundedDelta(d2, n4);
        if (!(bl || d2 == 0.0 && n8 == 0)) {
            this.dispatchScrollEvent(n, n2, n6, n8, d2);
        }
        double d3 = bl && d2 != 0.0 ? d2 : d;
        int n9 = n5 = bl && n8 != 0 ? n8 : n7;
        if (d3 != 0.0 || n5 != 0) {
            this.dispatchScrollEvent(n, n2, n6 |= 0x40, n5, d3);
        }
    }

    private void dispatchScrollEvent(int n, int n2, int n3, int n4, double d) {
        long l = System.currentTimeMillis();
        this.eventNotifier.notifyMouseWheelEvent(l, n, n2, n3, 0, 1, -n4, -d, null);
    }

    private void handleFlagChangedEvent(int n, short s) {
        int[] nArray = new int[]{n, s};
        int[] nArray2 = new int[3];
        NSEvent.nsKeyModifiersToJavaKeyInfo(nArray, nArray2);
        int n2 = nArray2[0];
        int n3 = nArray2[1];
        int n4 = nArray2[2];
        int n5 = NSEvent.nsToJavaKeyModifiers(n);
        long l = System.currentTimeMillis();
        if (n4 == 401) {
            this.lastKeyPressCode = n2;
        }
        this.eventNotifier.notifyKeyEvent(n4, l, n5, n2, '\uffff', n3);
    }

    private static char mapNsCharsToCompatibleWithJava(char c) {
        switch (c) {
            case '\u0003': 
            case '\r': {
                return '\n';
            }
            case '\uf728': {
                return '\b';
            }
            case '\u0019': {
                return '\t';
            }
        }
        return c;
    }

    void handleKeyEvent(NSEvent nSEvent) {
        LWCToolkit lWCToolkit;
        boolean bl;
        char c;
        if (useOldKeyEventProcessing) {
            this.handleKeyEvent(nSEvent.getType(), nSEvent.getModifierFlags(), nSEvent.getOldCharacters(), nSEvent.getOldCharactersIgnoringModifiers(), nSEvent.getKeyCode(), true, false);
            return;
        }
        boolean bl2 = this.isNpapiCallback ? nSEvent.getType() == 10 : nSEvent.getType() == 12;
        int n = 401;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        if (bl2) {
            this.handleFlagChangedEvent(nSEvent.getModifierFlags(), nSEvent.getKeyCode());
            return;
        }
        int n4 = NSEvent.nsToJavaKeyModifiers(nSEvent.getModifierFlags());
        boolean bl4 = (n4 & 0x380) == 0;
        boolean bl5 = (n4 & 0x40) != 0;
        boolean bl6 = bl4 && bl5;
        boolean bl7 = (n4 & 0x340) == 0;
        boolean bl8 = (n4 & 0x80) != 0;
        boolean bl9 = false;
        char c2 = c = nSEvent.getCharacters() == null || nSEvent.getCharacters().isEmpty() ? (char)'\uffff' : (char)nSEvent.getCharacters().charAt(0);
        if (bl7 && bl8 && Character.isISOControl(c)) {
            bl9 = true;
        }
        char c3 = '\uffff';
        boolean bl10 = nSEvent.getCharactersIgnoringModifiers() != null && nSEvent.getCharactersIgnoringModifiers().length() > 0;
        boolean bl11 = bl = nSEvent.getCharacters() != null && nSEvent.getCharacters().length() > 0;
        char c4 = bl10 ? (char)nSEvent.getCharactersIgnoringModifiers().charAt(0) : (c3 = bl ? (char)nSEvent.getCharacters().charAt(0) : (char)'\uffff');
        if (bl6 && nSEvent.getCharactersIgnoringModifiers() != null && !nSEvent.getCharactersIgnoringModifiers().isEmpty()) {
            c3 = nSEvent.getCharactersIgnoringModifiers().charAt(0);
        } else if (nSEvent.getCharactersIgnoringModifiersAndShift() != null && !nSEvent.getCharactersIgnoringModifiersAndShift().isEmpty()) {
            c3 = nSEvent.getCharactersIgnoringModifiersAndShift().charAt(0);
        } else if (nSEvent.getCharacters() != null && !nSEvent.getCharacters().isEmpty() && bl4 && bl5) {
            c3 = c;
        }
        int[] nArray = new int[]{c3, nSEvent.getModifierFlags(), nSEvent.isHasDeadKey() ? 1 : 0, nSEvent.getKeyCode()};
        int[] nArray2 = new int[3];
        bl3 = NSEvent.nsToJavaKeyInfo(nArray, nArray2);
        char c5 = c3;
        if (nSEvent.isHasDeadKey()) {
            c5 = (char)nArray2[2];
            n2 = nSEvent.getDeadKeyCode();
            if (c5 == '\u0000') {
                return;
            }
        }
        if ((lWCToolkit = (LWCToolkit)Toolkit.getDefaultToolkit()).getLockingKeyState(20) && Locale.SIMPLIFIED_CHINESE.equals(lWCToolkit.getDefaultKeyboardLocale())) {
            c5 = c3;
        }
        n2 = nArray2[0];
        n3 = nArray2[1];
        n = this.isNpapiCallback ? NSEvent.npToJavaEventType(nSEvent.getType()) : NSEvent.nsToJavaEventType(nSEvent.getType());
        c5 = bl9 ? c : CPlatformResponder.mapNsCharsToCompatibleWithJava(c5);
        String string = NSEvent.nsToJavaChar(c5, nSEvent.getModifierFlags());
        c5 = string == null ? (char)'\uffff' : (char)string.charAt(0);
        long l = System.currentTimeMillis();
        if (n == 401) {
            this.lastKeyPressCode = n2;
        }
        if ('\uf700' <= c5 && c5 <= '\uf8ff') {
            c5 = '\uffff';
        }
        this.eventNotifier.notifyKeyEvent(n, l, n4, n2, c5, n3);
        if (n == 401 && (bl3 &= true) && (n4 & 0x100) == 0) {
            boolean bl12;
            char c6 = '\uffff';
            if (nSEvent.getCharacters() != null) {
                c6 = CPlatformResponder.mapNsCharsToCompatibleWithJava(c);
                string = NSEvent.nsToJavaChar(c6, nSEvent.getModifierFlags());
                c6 = string == null ? (char)'\uffff' : (char)string.charAt(0);
            }
            boolean bl13 = bl12 = (n4 & 0x180) == 0;
            if (bl12 && c6 != '\uffff') {
                this.eventNotifier.notifyKeyEvent(400, l, n4, n2, c6, 0);
            }
        }
    }

    void handleInputEvent(String string) {
        if (string != null) {
            int n = string.length();
            char c = '\u0000';
            for (int i = 0; i < n; ++i) {
                c = string.charAt(i);
                this.eventNotifier.notifyKeyEvent(400, System.currentTimeMillis(), 0, 0, c, 0);
            }
            this.eventNotifier.notifyKeyEvent(402, System.currentTimeMillis(), 0, this.lastKeyPressCode, c, 0);
        }
    }

    @Deprecated
    void handleKeyEvent(int n, int n2, String string, String string2, short s, boolean bl, boolean bl2) {
        int[] nArray;
        boolean bl3;
        boolean bl4 = this.isNpapiCallback ? n == 10 : n == 12;
        int n3 = 401;
        int n4 = 0;
        int n5 = 0;
        boolean bl5 = false;
        int n6 = 65535;
        boolean bl6 = bl3 = string != null && string.length() == 0;
        if (bl4) {
            int[] nArray2 = new int[]{n2, s};
            nArray = new int[3];
            NSEvent.nsKeyModifiersToJavaKeyInfo(nArray2, nArray);
            n4 = nArray[0];
            n5 = nArray[1];
            n3 = nArray[2];
        } else {
            int[] nArray3;
            if (string != null && string.length() > 0) {
                n6 = string.charAt(0);
            }
            int n7 = string2 != null && string2.length() > 0 ? (int)string2.charAt(0) : 65535;
            nArray = new int[]{n7, bl3 ? 1 : 0, n2, s};
            bl5 = NSEvent.nsToJavaKeyInfoOld(nArray, nArray3 = new int[3]);
            if (!bl5) {
                n6 = 65535;
            }
            if (bl3 && (n6 = (int)((char)nArray3[2])) == 0) {
                return;
            }
            LWCToolkit lWCToolkit = (LWCToolkit)Toolkit.getDefaultToolkit();
            if (lWCToolkit.getLockingKeyState(20) && Locale.SIMPLIFIED_CHINESE.equals(lWCToolkit.getDefaultKeyboardLocale())) {
                n6 = n7;
            }
            n4 = nArray3[0];
            n5 = nArray3[1];
            n3 = this.isNpapiCallback ? NSEvent.npToJavaEventType(n) : NSEvent.nsToJavaEventType(n);
        }
        char c = NSEvent.nsToJavaCharOld((char)n6, n2);
        if (c == '\uffff') {
            bl5 = false;
        }
        int n8 = NSEvent.nsToJavaKeyModifiers(n2);
        long l = System.currentTimeMillis();
        if (n3 == 401) {
            this.lastKeyPressCode = n4;
        }
        this.eventNotifier.notifyKeyEvent(n3, l, n8, n4, c, n5);
        if (n3 == 401 && (bl5 &= bl) && (n8 & 0x100) == 0) {
            if (bl2 && (n4 == 10 || n4 == 32)) {
                return;
            }
            this.eventNotifier.notifyKeyEvent(400, l, n8, 0, c, 0);
            if (bl2) {
                this.eventNotifier.notifyKeyEvent(402, l, n8, n4, c, 0);
            }
        }
    }

    void handleWindowFocusEvent(boolean bl, LWWindowPeer lWWindowPeer) {
        this.eventNotifier.notifyActivation(bl, lWWindowPeer);
    }

    static class DeltaAccumulator {
        double accumulatedDelta;
        boolean accumulate;

        DeltaAccumulator() {
        }

        int getRoundedDelta(double d, int n) {
            int n2 = (int)Math.round(d);
            if (n == 1) {
                if (n2 == 0 && d != 0.0) {
                    n2 = d > 0.0 ? 1 : -1;
                }
            } else {
                if (n == 2) {
                    this.accumulatedDelta = 0.0;
                    this.accumulate = true;
                } else if (n == 4) {
                    this.accumulate = true;
                }
                if (this.accumulate) {
                    this.accumulatedDelta += d;
                    n2 = (int)Math.round(this.accumulatedDelta);
                    this.accumulatedDelta -= (double)n2;
                    if (n == 5) {
                        this.accumulate = false;
                    }
                }
            }
            return n2;
        }
    }
}

