/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.ShowDiffOnUmlAction;
import com.intellij.uml.utils.UmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ShowChangesAction
extends ShowDiffOnUmlAction {
    private String title;

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.title = null;
        Project project = e.getProject();
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        List changeLists = ChangeListManager.getInstance((Project)project).getChangeLists();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("diagram.show.diff");
        if (changeLists.size() > 1) {
            ArrayList<String> titles = new ArrayList<String>();
            for (LocalChangeList changeList : changeLists) {
                titles.add(changeList.getName());
            }
            JBList jbList = new JBList(titles);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)jbList).setItemChoosenCallback(() -> {
                this.title = (String)jbList.getSelectedValue();
                this.run(project, point);
            }).setTitle("Select Change List").createPopup().showInBestPositionFor(e.getDataContext());
        } else {
            this.title = ((LocalChangeList)changeLists.get(0)).getName();
            this.run(project, point);
        }
    }

    private void run(Project project, RelativePoint point) {
        LocalChangeList changeList = this.getChangeList(project);
        if (changeList != null) {
            if (changeList.getChanges().size() <= 50) {
                this.showUnderProgress(DiffUmlProvider.INSTANCE, project, null, Collections.emptyList(), point);
            } else {
                DiagramAction.showNotification((String)UmlBundle.message("change.list.contains.too.many.files", this.title, 50), (RelativePoint)point);
            }
        }
    }

    @Override
    protected String getTitle(Project project, Object element, DiagramProvider provider, DiagramState presentation, Collection additionalElements) {
        LocalChangeList list = this.getChangeList(project);
        return list == null ? "Changes" : "Changes for '" + list.getName() + "'";
    }

    @Override
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0;
        e.getPresentation().setEnabled(enabled);
        if (enabled && ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            boolean bl = enabled = files != null && files.length > 0;
            if (enabled) {
                boolean containsChanged = false;
                for (VirtualFile file : files) {
                    FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
                    if (status != FileStatus.ADDED && status != FileStatus.MODIFIED) continue;
                    containsChanged = true;
                    break;
                }
                enabled = containsChanged;
            }
        }
        e.getPresentation().setVisible(enabled);
    }

    @Nullable
    protected LocalChangeList getChangeList(Project project) {
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0 && this.title != null) {
            for (LocalChangeList list : ChangeListManager.getInstance((Project)project).getChangeLists()) {
                if (!list.getName().equals(this.title)) continue;
                return list;
            }
        }
        return null;
    }

    @Override
    protected VirtualFile getVirtualFile(Project project, DiagramProvider provider) {
        String url = "uml://" + provider.getID() + "/" + "$SHOW_CHANGES$";
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        LocalChangeList list = this.getChangeList(project);
        if (list != null && virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
            String text = "Changes for '" + list.getName() + "'";
            file.setPresentableName(text);
            file.putUserData(DiffUmlProvider.CHANGE_LIST, list);
            UmlVirtualFileSystem.setInitialized(file);
            return file;
        }
        return super.getVirtualFile(project, provider);
    }
}

