/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.editor.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.TextMateFileType;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

public class TextMateServiceImpl
extends TextMateService {
    private final Map<String, TextMateCustomTextAttributes> myCustomHighlightingColors = ContainerUtil.newHashMap();
    private final XmlPlistReader myPlistReader = new XmlPlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final Map<String, TextMateTheme> myThemeHashMap = ContainerUtil.newHashMap();
    private final SnippetsRegistry mySnippetsRegistry = new SnippetsRegistry();
    private final PreferencesRegistry myPreferencesRegistry = new PreferencesRegistry();
    private final ShellVariablesRegistry myShellVariablesRegistry = new ShellVariablesRegistry();
    private final Map<String, String> myExtensionsMapping = ContainerUtil.newHashMap();
    @NonNls
    private static final String PREINSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getPreInstalledPluginsPath(), "textmate", "lib", "themes"});
    @NonNls
    private static final String INSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getPluginsPath(), "textmate", "lib", "themes"});
    private final Set<TextMateService.TextMateBundleListener> myListeners = ContainerUtil.newHashSet();

    @Override
    public void registerEnabledBundles(boolean fireFileEvents) {
        TextMateSettings settings = TextMateSettings.getInstance();
        if (settings != null) {
            Collection<BundleConfigBean> bundles = settings.getBundles();
            for (BundleConfigBean bundleConfigBean : bundles) {
                boolean result;
                if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), fireFileEvents))) continue;
                Notifications.Bus.notify((Notification)new Notification("TextMate Bundles", "TextMate bundle load error", "Bundle " + bundleConfigBean.getName() + " can't be registered", NotificationType.ERROR, null));
            }
            this.cleanUpRedundantAssociations();
        }
    }

    @Override
    public void unregisterAllBundles(boolean unregisterFileTypes) {
        if (unregisterFileTypes) {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                for (FileNameMatcher matcher : fileTypeManager.getAssociations((FileType)TextMateFileType.INSTANCE)) {
                    fileTypeManager.removeAssociation((FileType)TextMateFileType.INSTANCE, matcher, false);
                }
            }));
        }
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    public void addListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void clearListeners() {
        this.myListeners.clear();
    }

    @Override
    @NotNull
    public XmlPlistReader getPlistReader() {
        XmlPlistReader xmlPlistReader = this.myPlistReader;
        if (xmlPlistReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getPlistReader"));
        }
        return xmlPlistReader;
    }

    @Override
    @NotNull
    public Map<String, TextMateCustomTextAttributes> getCustomHighlightingColors() {
        Map<String, TextMateCustomTextAttributes> map = this.myCustomHighlightingColors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getCustomHighlightingColors"));
        }
        return map;
    }

    @Override
    @NotNull
    public List<Preferences> getPreferencesForSelector(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getPreferencesForSelector"));
        }
        List<Preferences> list = this.myPreferencesRegistry.getPreferences(selector);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getPreferencesForSelector"));
        }
        return list;
    }

    @Override
    @Nullable
    public String getVariableValue(@NotNull String name, @NotNull EditorEx editor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getVariableValue"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getVariableValue"));
        }
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        SnippetsRegistry snippetsRegistry = this.mySnippetsRegistry;
        if (snippetsRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getSnippetsRegistry"));
        }
        return snippetsRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getLanguageDescriptorByFileName"));
        }
        for (String extension : TextMateServiceImpl.getExtensions(fileName)) {
            TextMateLanguageDescriptor languageDescriptor = this.getLanguageDescriptorByExtension(extension);
            if (languageDescriptor == null) continue;
            return languageDescriptor;
        }
        return null;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(String extension) {
        String scopeName = this.myExtensionsMapping.get(extension);
        return StringUtil.isNotEmpty((String)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerTheme(@Nullable VirtualFile themeFile) {
        if (themeFile == null || !themeFile.isValid()) {
            return false;
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            try {
                TextMateTheme theme = TextMateTheme.load(this.myPlistReader.read(themeFile.getInputStream()));
                if (theme != TextMateTheme.EMPTY_THEME) {
                    this.myThemeHashMap.put(theme.getName(), theme);
                    for (TextMateService.TextMateBundleListener listener : this.myListeners) {
                        listener.colorSchemeChanged();
                    }
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String[] getThemeNames() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String[] stringArray = ArrayUtil.toStringArray(this.myThemeHashMap.keySet());
        // MONITOREXIT : map
        if (stringArray != null) return stringArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getThemeNames"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public TextMateTheme getCurrentTheme() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String currentIdeaSchemeName = EditorColorsManager.getInstance().getGlobalScheme().getName();
        String textmateSchemeName = TextMateSettings.getInstance().getTextMateThemeName(currentIdeaSchemeName, this);
        String schemeName = this.myThemeHashMap.containsKey(textmateSchemeName) ? textmateSchemeName : "Mac Classic";
        TextMateTheme scheme = this.myThemeHashMap.get(schemeName);
        TextMateTheme textMateTheme = scheme != null ? scheme : TextMateTheme.EMPTY_THEME;
        // MONITOREXIT : map
        if (textMateTheme != null) return textMateTheme;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getCurrentTheme"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadThemesFromDisk() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            this.myThemeHashMap.clear();
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile themesDirectory = LocalFileSystem.getInstance().findFileByPath(INSTALLED_THEMES_PATH);
            if (themesDirectory == null) {
                themesDirectory = LocalFileSystem.getInstance().findFileByPath(PREINSTALLED_THEMES_PATH);
            }
            if (themesDirectory != null) {
                VirtualFile finalThemesDirectory = themesDirectory;
                Runnable reloadThemes = () -> {
                    Map<String, TextMateTheme> map = this.myThemeHashMap;
                    synchronized (map) {
                        if (finalThemesDirectory.isValid()) {
                            for (VirtualFile themeFile : finalThemesDirectory.getChildren()) {
                                this.registerTheme(themeFile);
                            }
                        }
                    }
                };
                if (ModalityState.current() == ModalityState.NON_MODAL) {
                    themesDirectory.refresh(true, false, reloadThemes);
                } else {
                    reloadThemes.run();
                }
            }
        });
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            return this.myBundleFactory.fromDirectory(new File(path));
        }
        return null;
    }

    private boolean registerBundle(VirtualFile directory, boolean fireFileEvents) {
        Bundle bundle = this.createBundle(directory);
        if (bundle != null) {
            this.registerLanguageSupport(bundle, fireFileEvents);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            this.registerThemes(bundle);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemes(@NotNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "registerThemes"));
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            for (File themeFile : bundle.getThemeFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)themeFile, (boolean)true);
                this.registerTheme(virtualFile);
            }
        }
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "registerSnippets"));
        }
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet(snippetFile, this.myPlistReader.read(snippetFile));
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "registerPreferences"));
        }
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                Plist plist = this.myPlistReader.read(preferenceFile);
                Pair<String, Plist> settingsPair = PreferencesReadUtil.retrieveSettingsPlist(plist);
                if (settingsPair == null) continue;
                this.myPreferencesRegistry.fillFromPList((String)settingsPair.first, (Plist)settingsPair.second);
                this.myShellVariablesRegistry.fillVariablesFromPlist((String)settingsPair.first, (Plist)settingsPair.second);
                this.readCustomHighlightingColors((String)settingsPair.first, (Plist)settingsPair.second);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull String scopeName, @NotNull Plist preferencesPList) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "readCustomHighlightingColors"));
        }
        if (preferencesPList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferencesPList", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "readCustomHighlightingColors"));
        }
        TextAttributes textAttributes = new TextAttributes();
        boolean hasHighlightingSettings = PreferencesReadUtil.fillTextAttributes(textAttributes, preferencesPList, null);
        if (hasHighlightingSettings) {
            double backgroundAlpha = PreferencesReadUtil.getBackgroundAlpha(preferencesPList);
            this.myCustomHighlightingColors.put(scopeName, new TextMateCustomTextAttributes(textAttributes, backgroundAlpha));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, boolean fireFileEvents) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "registerLanguageSupport"));
        }
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                String rootScopeName = this.mySyntaxTable.loadSyntax(plist);
                List<String> extensions = plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
                for (String extension : extensions) {
                    this.myExtensionsMapping.put(extension, rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
        TextMateServiceImpl.registerTextMateExtensions(this.myExtensionsMapping.keySet(), fireFileEvents);
    }

    private void cleanUpRedundantAssociations() {
        HashSet associationsToDelete = ContainerUtil.newHashSet();
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        for (FileNameMatcher nameMatcher : fileTypeManager.getAssociations((FileType)TextMateFileType.INSTANCE)) {
            String typeKey;
            if (nameMatcher instanceof ExtensionFileNameMatcher) {
                typeKey = ((ExtensionFileNameMatcher)nameMatcher).getExtension();
            } else {
                if (!(nameMatcher instanceof ExactFileNameMatcher)) continue;
                typeKey = ((ExactFileNameMatcher)nameMatcher).getFileName();
            }
            if (this.myExtensionsMapping.containsKey(typeKey)) continue;
            associationsToDelete.add(nameMatcher);
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> WriteAction.run(() -> {
            for (FileNameMatcher nameMatcher : associationsToDelete) {
                fileTypeManager.removeAssociation((FileType)TextMateFileType.INSTANCE, nameMatcher, false);
            }
            if (!associationsToDelete.isEmpty()) {
                fileTypeManager.fireBeforeFileTypesChanged();
                fileTypeManager.fireFileTypesChanged();
            }
        }));
    }

    private static void registerTextMateExtensions(@NotNull Collection<String> extensions, boolean fireFileEvents) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "registerTextMateExtensions"));
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            if (extensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "lambda$registerTextMateExtensions$7"));
            }
            WriteAction.run(() -> {
                if (extensions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "lambda$null$6"));
                }
                boolean fileTypeUpdated = false;
                FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
                for (String extension : extensions) {
                    FileType registeredType = fileTypeManager.getFileTypeByFileName(extension);
                    if (TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(registeredType)) {
                        fileTypeManager.associate((FileType)TextMateFileType.INSTANCE, FileTypeManager.parseFromString((String)extension), false);
                        fileTypeUpdated = true;
                    }
                    if (!TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(registeredType = fileTypeManager.getFileTypeByExtension(extension))) continue;
                    fileTypeManager.associate((FileType)TextMateFileType.INSTANCE, (FileNameMatcher)new ExtensionFileNameMatcher(extension), false);
                    fileTypeUpdated = true;
                }
                if (fireFileEvents && fileTypeUpdated) {
                    fileTypeManager.fireBeforeFileTypesChanged();
                    fileTypeManager.fireFileTypesChanged();
                }
            });
        });
    }

    public static boolean isTypeShouldBeReplacedByTextMateType(FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == TextMateFileType.INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }

    public static Collection<String> getExtensions(@NotNull String name) {
        String extension;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/textmate/TextMateServiceImpl", "getExtensions"));
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])new String[]{name});
        int index = name.indexOf(46);
        while (index >= 0 && !(extension = name.substring(index + 1)).isEmpty()) {
            result.add(extension);
            index = name.indexOf(46, index + 1);
        }
        return result;
    }
}

