/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.BundleType;

public class Bundle {
    private static final FileFilter SYNTAX_FILES_FILTER = new BundleFilesFilter("tmlanguage", "plist");
    private static final FileFilter PREFERENCE_FILES_FILTER = new BundleFilesFilter("tmpreferences", "plist");
    private static final FileFilter THEME_FILES_FILTER = new BundleFilesFilter("tmtheme", "plist");
    private final String myName;
    private final String pathToBundleFile;
    private final BundleType myType;

    public Bundle(@NotNull String name, @NotNull String bundle, @NotNull BundleType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/textmate/bundles/Bundle", "<init>"));
        }
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/plugins/textmate/bundles/Bundle", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/textmate/bundles/Bundle", "<init>"));
        }
        this.myName = name;
        this.pathToBundleFile = bundle;
        this.myType = type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getName"));
        }
        return string;
    }

    @NotNull
    public Collection<File> getGrammarFiles() {
        Collection<File> collection = this.getFilesInBundle(this.myType.getSyntaxesPath(), SYNTAX_FILES_FILTER);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getGrammarFiles"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getPreferenceFiles() {
        Collection<File> collection = this.getFilesInBundle(this.myType.getPreferencesPath(), PREFERENCE_FILES_FILTER);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getPreferenceFiles"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getThemeFiles() {
        Collection<File> collection = this.getFilesInBundle(this.myType.getThemesPath(), THEME_FILES_FILTER);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getThemeFiles"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getSnippetFiles() {
        Collection<File> collection = this.getFilesInBundle(this.myType.getSnippetsPath(), new BundleFilesFilter(this.myType.getSnippetFileExtensions()));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getSnippetFiles"));
        }
        return collection;
    }

    @NotNull
    public BundleType getType() {
        BundleType bundleType = this.myType;
        if (bundleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getType"));
        }
        return bundleType;
    }

    @NotNull
    private Collection<File> getFilesInBundle(@NotNull String path, @Nullable FileFilter filter) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/textmate/bundles/Bundle", "getFilesInBundle"));
        }
        File directory = new File(this.pathToBundleFile, path);
        Object[] files = null;
        try {
            files = directory.listFiles(filter);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        HashSet hashSet = files != null && files.length > 0 ? ContainerUtil.newHashSet((Object[])files) : Collections.emptySet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/Bundle", "getFilesInBundle"));
        }
        return hashSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        return this.pathToBundleFile.equals(bundle.pathToBundleFile);
    }

    public int hashCode() {
        return this.pathToBundleFile.hashCode();
    }

    public String toString() {
        return "Bundle{name='" + this.myName + '\'' + ", path='" + this.pathToBundleFile + '\'' + ", type=" + (Object)((Object)this.myType) + '}';
    }

    public static class BundleFilesFilter
    implements FileFilter {
        private final Set<String> myExtensions;

        public BundleFilesFilter(String ... extensions) {
            this.myExtensions = ContainerUtil.newHashSet((Object[])extensions);
        }

        @Override
        public boolean accept(@NotNull File path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/textmate/bundles/Bundle$BundleFilesFilter", "accept"));
            }
            return this.myExtensions.contains(FileUtilRt.getExtension((String)path.getName()).toLowerCase(Locale.US));
        }
    }
}

