/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BundleType {
    TEXTMATE("Syntaxes", "Preferences", "Themes", "Snippets", "tmsnippet", "plist"),
    SUBLIME("", "", "schemes", "", "sublime-snippet"),
    UNDEFINED;

    private final String mySyntaxesPath;
    private final String myPreferencesPath;
    private final String mySnippetsPath;
    private final String[] mySnippetFileExtensions;
    private final String myThemesPath;

    private BundleType() {
        this(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private BundleType(String[] snippetFileExtensions) {
        if (snippetFileExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snippetFileExtensions", "org/jetbrains/plugins/textmate/bundles/BundleType", "<init>"));
        }
        this("", "", "", "", snippetFileExtensions);
    }

    private BundleType(@NotNull String syntaxesPath, @NotNull String preferencesPath, String themesPath, String snippetsPath, String ... snippetFileExtension) {
        if (syntaxesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxesPath", "org/jetbrains/plugins/textmate/bundles/BundleType", "<init>"));
        }
        if (preferencesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferencesPath", "org/jetbrains/plugins/textmate/bundles/BundleType", "<init>"));
        }
        if (themesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themesPath", "org/jetbrains/plugins/textmate/bundles/BundleType", "<init>"));
        }
        if (snippetsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snippetsPath", "org/jetbrains/plugins/textmate/bundles/BundleType", "<init>"));
        }
        this.mySyntaxesPath = syntaxesPath;
        this.myPreferencesPath = preferencesPath;
        this.mySnippetsPath = snippetsPath;
        this.mySnippetFileExtensions = snippetFileExtension;
        this.myThemesPath = themesPath;
    }

    @NotNull
    String getPreferencesPath() {
        String string = this.myPreferencesPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "getPreferencesPath"));
        }
        return string;
    }

    @NotNull
    String getSyntaxesPath() {
        String string = this.mySyntaxesPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "getSyntaxesPath"));
        }
        return string;
    }

    @NotNull
    String getSnippetsPath() {
        String string = this.mySnippetsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "getSnippetsPath"));
        }
        return string;
    }

    public String getThemesPath() {
        return this.myThemesPath;
    }

    @NotNull
    String[] getSnippetFileExtensions() {
        if (this.mySnippetFileExtensions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "getSnippetFileExtensions"));
        }
        return this.mySnippetFileExtensions;
    }

    @NotNull
    static BundleType fromDirectory(@Nullable File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            if ("tmBundle".equalsIgnoreCase(FileUtilRt.getExtension((String)directory.getName()))) {
                BundleType bundleType = TEXTMATE;
                if (bundleType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "fromDirectory"));
                }
                return bundleType;
            }
            File infoPlist = new File(directory, "info.plist");
            boolean hasInfoPlistFile = infoPlist.exists() && infoPlist.isFile();
            File[] children = directory.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (hasInfoPlistFile && child.isDirectory() && "Syntaxes".equalsIgnoreCase(child.getName())) {
                        BundleType bundleType = TEXTMATE;
                        if (bundleType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "fromDirectory"));
                        }
                        return bundleType;
                    }
                    String fileExtension = FileUtilRt.getExtension((String)child.getName());
                    if (!"tmLanguage".equalsIgnoreCase(fileExtension) && !"tmPreferences".equalsIgnoreCase(fileExtension)) continue;
                    BundleType bundleType = SUBLIME;
                    if (bundleType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "fromDirectory"));
                    }
                    return bundleType;
                }
            }
            if (hasInfoPlistFile) {
                BundleType bundleType = TEXTMATE;
                if (bundleType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "fromDirectory"));
                }
                return bundleType;
            }
        }
        BundleType bundleType = UNDEFINED;
        if (bundleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/bundles/BundleType", "fromDirectory"));
        }
        return bundleType;
    }
}

