/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;

public class TextMateBundlesListPanel
implements Disposable {
    private final CheckBoxList<BundleConfigBean> myBundlesList;
    private Collection<TextMateBundlesChangeStateListener> myListeners = ContainerUtil.newArrayList();

    public TextMateBundlesListPanel() {
        this.myBundlesList = new CheckBoxList<BundleConfigBean>(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                BundleConfigBean itemAt = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(index);
                if (itemAt != null) {
                    itemAt.setEnabled(value);
                }
            }
        }){

            @Nullable
            protected String getSecondaryText(int index) {
                BundleConfigBean itemAt = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(index);
                return itemAt != null ? itemAt.getPath() : null;
            }
        };
        this.myBundlesList.setSelectionMode(2);
        new ListSpeedSearch(this.myBundlesList, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((JCheckBox)o).getText();
            }
        });
    }

    @NotNull
    public List<BundleConfigBean> getState() {
        ArrayList result = ContainerUtil.newArrayList();
        for (int i = 0; i < this.myBundlesList.getItemsCount(); ++i) {
            result.add(this.myBundlesList.getItemAt(i));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel", "getState"));
        }
        return arrayList;
    }

    public void setState(@NotNull Collection<BundleConfigBean> configBeans) {
        if (configBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configBeans", "org/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel", "setState"));
        }
        this.myBundlesList.clear();
        for (BundleConfigBean bean : configBeans) {
            this.myBundlesList.addItem((Object)bean.copy(), bean.getName(), bean.isEnabled());
        }
    }

    public void addChangeStateListener(TextMateBundlesChangeStateListener listener) {
        this.myListeners.add(listener);
    }

    public JPanel createMainComponent() {
        return ToolbarDecorator.createDecorator(this.myBundlesList).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List bundlesToDelete = ContainerUtil.findAll((Collection)TextMateBundlesListPanel.this.myBundlesList.getSelectedValuesList(), JCheckBox.class);
                if (bundlesToDelete.isEmpty()) {
                    return;
                }
                String title = bundlesToDelete.size() > 1 ? "Delete Bundles?" : "Delete Bundle?";
                String message = StringUtil.join((Collection)bundlesToDelete, AbstractButton::getText, (String)"\n");
                if (Messages.showYesNoDialog((String)message, (String)title, (String)"Delete", (String)"Cancel", null) != 0) {
                    return;
                }
                ListUtil.removeSelectedItems((JList)TextMateBundlesListPanel.this.myBundlesList);
                TextMateBundlesListPanel.this.fireStateChanged();
            }
        }).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VirtualFile[] bundleDirectories;
                BundleConfigBean lastAddedBundle;
                FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), null, (Component)TextMateBundlesListPanel.this.myBundlesList);
                VirtualFile fileToSelect = null;
                int itemsCount = TextMateBundlesListPanel.this.myBundlesList.getItemsCount();
                if (itemsCount > 0 && (lastAddedBundle = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(itemsCount - 1)) != null) {
                    fileToSelect = LocalFileSystem.getInstance().findFileByPath(lastAddedBundle.getPath());
                }
                if ((bundleDirectories = fileChooser.choose(null, new VirtualFile[]{fileToSelect})).length > 0) {
                    StringBuilder errorMessage = new StringBuilder();
                    for (VirtualFile bundleDirectory : bundleDirectories) {
                        ThrowableComputable readBundleProcess = () -> TextMateService.getInstance().createBundle(bundleDirectory);
                        Bundle bundle = null;
                        try {
                            bundle = (Bundle)ProgressManager.getInstance().runProcessWithProgressSynchronously(readBundleProcess, "Add Bundle", true, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String bundleDirectoryPath = bundleDirectory.getPath();
                        if (bundle != null) {
                            boolean alreadyAdded = false;
                            for (int i = 0; i < TextMateBundlesListPanel.this.myBundlesList.getItemsCount(); ++i) {
                                BundleConfigBean item = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(i);
                                if (item == null || !bundleDirectoryPath.equals(item.getPath())) continue;
                                TextMateBundlesListPanel.this.myBundlesList.clearSelection();
                                TextMateBundlesListPanel.this.myBundlesList.setSelectedIndex(i);
                                UIUtil.scrollListToVisibleIfNeeded((JList)TextMateBundlesListPanel.this.myBundlesList);
                                alreadyAdded = true;
                                break;
                            }
                            if (alreadyAdded) continue;
                            TextMateBundlesListPanel.this.myBundlesList.addItem((Object)new BundleConfigBean(bundle.getName(), bundleDirectoryPath, true), bundle.getName(), true);
                            TextMateBundlesListPanel.this.fireStateChanged();
                            continue;
                        }
                        if (errorMessage.length() == 0) {
                            errorMessage.append("Can't read following bundles:");
                        }
                        errorMessage.append('\n').append(bundleDirectoryPath);
                    }
                    if (errorMessage.length() > 0) {
                        Messages.showErrorDialog((String)errorMessage.toString(), (String)"TextMate Bundle Error");
                    }
                }
            }
        }).createPanel();
    }

    private void fireStateChanged() {
        for (TextMateBundlesChangeStateListener listener : this.myListeners) {
            listener.stateChanged();
        }
    }

    public boolean isModified(@NotNull Collection<BundleConfigBean> bundles) {
        if (bundles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundles", "org/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel", "isModified"));
        }
        return !this.getState().equals(bundles);
    }

    public void dispose() {
        this.myListeners.clear();
        this.myListeners = null;
    }

    static interface TextMateBundlesChangeStateListener {
        public void stateChanged();
    }
}

