/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMateErrorPanel
extends JPanel {
    public TextMateErrorPanel(@NotNull String errorText, @NotNull String actionText, @NotNull LinkListener actionLinkListener) {
        if (errorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        if (actionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        if (actionLinkListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLinkListener", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        this(errorText, actionText, actionLinkListener, null);
    }

    public TextMateErrorPanel(@NotNull String errorText, @NotNull String actionText, @NotNull LinkListener actionLinkListener, @Nullable Icon actionIcon) {
        if (errorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        if (actionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        if (actionLinkListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLinkListener", "org/jetbrains/plugins/textmate/configuration/TextMateErrorPanel", "<init>"));
        }
        super(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 5, 0, UIUtil.getPanelBackground()), BorderFactory.createLineBorder(UIUtil.getPanelBackground().darker())));
        JLabel errorLabel = new JLabel(errorText);
        errorLabel.setBackground(MessageType.WARNING.getPopupBackground());
        errorLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        errorLabel.setOpaque(true);
        LinkLabel actionLabel = new LinkLabel(actionText, actionIcon);
        actionLabel.setBackground(MessageType.WARNING.getPopupBackground());
        actionLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        actionLabel.setOpaque(true);
        actionLabel.setListener(actionLinkListener, null);
        this.add((Component)errorLabel, "Center");
        this.add((Component)actionLabel, "East");
    }
}

