/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.configuration.TextMateErrorPanel;

public class TextMateExtensionsIntersectionDialog
extends DialogWrapper {
    @NonNls
    private static final String REVERT_LINK_LABEL = "Revert";
    @NonNls
    private static final String INITIAL_LINK_LABEL = "Unregister native file type";
    private JPanel contentPane;
    private JBScrollPane myScrollPane;
    private JPanel myErrorsListPanel;
    private static final int MAX_ERRORS_COUNT = 7;
    private final Map<String, FileType> myConflictsToResolve;
    private final Map<String, FileType> myConflicts;
    private GridBagLayout myErrorListLayout;

    public TextMateExtensionsIntersectionDialog(@NotNull Component parent, @NotNull Map<String, FileType> conflicts, @NotNull Map<String, FileType> conflictsToResolve) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/textmate/configuration/TextMateExtensionsIntersectionDialog", "<init>"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "org/jetbrains/plugins/textmate/configuration/TextMateExtensionsIntersectionDialog", "<init>"));
        }
        if (conflictsToResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictsToResolve", "org/jetbrains/plugins/textmate/configuration/TextMateExtensionsIntersectionDialog", "<init>"));
        }
        super(parent, false);
        this.$$$setupUI$$$();
        this.setTitle("Extensions Conflicts");
        this.setModal(true);
        this.myConflicts = conflicts;
        this.myConflictsToResolve = ContainerUtil.newHashMap(conflictsToResolve);
        this.paintErrors();
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void createUIComponents() {
        this.myScrollPane = new JBScrollPane();
        this.myErrorListLayout = new GridBagLayout();
        this.myErrorsListPanel = new JPanel(this.myErrorListLayout);
        this.myErrorsListPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
    }

    public Map<String, FileType> getConflictsToResolve() {
        return this.myConflictsToResolve;
    }

    private void paintErrors() {
        List<TextMateErrorPanel> errors = this.createErrorPanels();
        int preferredHeight = 0;
        int preferredWidth = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 11;
        constraints.fill = 2;
        for (int i = 0; i < errors.size(); ++i) {
            TextMateErrorPanel errorPanel = errors.get(i);
            if (i == errors.size() - 1) {
                constraints.weighty = 1.0;
            }
            this.myErrorListLayout.setConstraints(errorPanel, constraints);
            this.myErrorListLayout.addLayoutComponent(errorPanel, constraints);
            this.myErrorsListPanel.add((Component)errorPanel, constraints);
            if (i != 7) continue;
            preferredHeight = this.myErrorsListPanel.getPreferredSize().height;
            preferredWidth = this.myErrorsListPanel.getPreferredSize().width;
        }
        if (preferredWidth > 0 && preferredHeight > 0) {
            this.myScrollPane.setPreferredSize(new Dimension(preferredWidth + 2 * UIUtil.getScrollBarWidth(), preferredHeight));
        }
        this.myScrollPane.revalidate();
        this.myScrollPane.repaint();
    }

    private List<TextMateErrorPanel> createErrorPanels() {
        ArrayList errors = ContainerUtil.newArrayListWithCapacity((int)this.myConflicts.size());
        for (Map.Entry<String, FileType> entry : this.myConflicts.entrySet()) {
            final String extension = entry.getKey();
            final FileType fileType = entry.getValue();
            String labelName = this.myConflictsToResolve.get(extension) != fileType ? INITIAL_LINK_LABEL : REVERT_LINK_LABEL;
            errors.add(new TextMateErrorPanel("Extension '" + extension + "' already registered by " + fileType.getName(), labelName, new LinkListener(){

                public void linkSelected(@NotNull LinkLabel aSource, Object aLinkData) {
                    if (aSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aSource", "org/jetbrains/plugins/textmate/configuration/TextMateExtensionsIntersectionDialog$1", "linkSelected"));
                    }
                    if (TextMateExtensionsIntersectionDialog.this.myConflictsToResolve.get(extension) != fileType) {
                        TextMateExtensionsIntersectionDialog.this.myConflictsToResolve.put(extension, fileType);
                        aSource.setText(TextMateExtensionsIntersectionDialog.REVERT_LINK_LABEL);
                    } else {
                        TextMateExtensionsIntersectionDialog.this.myConflictsToResolve.remove(extension);
                        aSource.setText(TextMateExtensionsIntersectionDialog.INITIAL_LINK_LABEL);
                    }
                }
            }));
        }
        return errors;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = this.myErrorsListPanel;
        jBScrollPane.setViewportView(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

