/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;

@State(name="TextMateSettings", storages={@Storage(value="textmate.xml")})
public class TextMateSettings
implements PersistentStateComponent<TextMateSettingsState> {
    @NonNls
    public static final String DEFAULT_THEME_NAME = "Mac Classic";
    private TextMateSettingsState myState;

    public static TextMateSettings getInstance() {
        return (TextMateSettings)ServiceManager.getService(TextMateSettings.class);
    }

    @Nullable
    public TextMateSettingsState getState() {
        return this.myState;
    }

    public void loadState(TextMateSettingsState state) {
        this.myState = state;
    }

    public Collection<BundleConfigBean> getBundles() {
        return this.myState != null ? this.myState.getBundles() : Collections.emptyList();
    }

    @NotNull
    public String getTextMateThemeName(@NotNull String generalThemeName, @Nullable TextMateService textMateService) {
        String result;
        if (generalThemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalThemeName", "org/jetbrains/plugins/textmate/configuration/TextMateSettings", "getTextMateThemeName"));
        }
        if (textMateService == null) {
            if (DEFAULT_THEME_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateSettings", "getTextMateThemeName"));
            }
            return DEFAULT_THEME_NAME;
        }
        String string = result = this.myState != null ? this.myState.getThemesMapping().get(generalThemeName) : null;
        if (result != null) {
            String string2 = result;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateSettings", "getTextMateThemeName"));
            }
            return string2;
        }
        for (String name : textMateService.getThemeNames()) {
            if (!name.equalsIgnoreCase(generalThemeName)) continue;
            result = name;
            break;
        }
        result = (String)ObjectUtils.notNull((Object)result, (Object)DEFAULT_THEME_NAME);
        if (this.myState != null) {
            this.myState.getThemesMapping().put(generalThemeName, result);
        }
        String string3 = result;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateSettings", "getTextMateThemeName"));
        }
        return string3;
    }

    public static class TextMateSettingsState {
        private Map<String, String> themesMapping;
        private Collection<BundleConfigBean> bundles = ContainerUtil.newArrayList();

        public TextMateSettingsState() {
            this(new HashMap<String, String>());
        }

        public TextMateSettingsState(Map<String, String> themesMapping) {
            this.themesMapping = themesMapping;
        }

        @NotNull
        public Map<String, String> getThemesMapping() {
            Map<String, String> map = this.themesMapping;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/configuration/TextMateSettings$TextMateSettingsState", "getThemesMapping"));
            }
            return map;
        }

        public Collection<BundleConfigBean> getBundles() {
            return this.bundles;
        }

        public void setBundles(Collection<BundleConfigBean> bundles) {
            ArrayList newList = ContainerUtil.newArrayListWithCapacity((int)bundles.size());
            for (BundleConfigBean bundle : bundles) {
                newList.add(bundle.copy());
            }
            this.bundles = newList;
        }

        public void setThemesMapping(Map<String, String> themesMapping) {
            this.themesMapping = themesMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextMateSettingsState state = (TextMateSettingsState)o;
            return this.bundles.equals(state.bundles);
        }

        public int hashCode() {
            return this.bundles.hashCode();
        }
    }
}

