/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;

public class TextMateBraceMatcher
implements BraceMatcher {
    public int getBraceTokenGroupId(IElementType tokenType) {
        return -1;
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        int start = iterator.getStart();
        if (iterator.getEnd() - start == 1) {
            String currentSelector = tokenType != null ? tokenType.toString() : null;
            return TextMateEditorUtils.getHighlightingPairForLeftChar(fileText.charAt(start), currentSelector) != null;
        }
        return false;
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        int start = iterator.getStart();
        if (iterator.getEnd() - start == 1) {
            String currentSelector = tokenType != null ? tokenType.toString() : null;
            return TextMateEditorUtils.getHighlightingPairForRightChar(fileText.charAt(start), currentSelector) != null;
        }
        return false;
    }

    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        return true;
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        return false;
    }

    @Nullable
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/textmate/editor/TextMateBraceMatcher", "getOppositeBraceTokenType"));
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "org/jetbrains/plugins/textmate/editor/TextMateBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

