/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public final class TextMateEditorUtils {
    @Nullable
    public static String getCurrentScopeSelector(@NotNull EditorEx editor) {
        TextMateLanguageDescriptor languageDescriptor;
        VirtualFile file;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/textmate/editor/TextMateEditorUtils", "getCurrentScopeSelector"));
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        String result = null;
        if (offset != 0 || !iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            String string = result = tokenType != null ? tokenType.toString() : null;
        }
        if (result == null && (file = editor.getVirtualFile()) != null && (languageDescriptor = TextMateService.getInstance().getLanguageDescriptorByFileName(file.getName())) != null) {
            return languageDescriptor.getScopeName();
        }
        return result;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForLeftChar(char c, @Nullable String currentSelector) {
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getHighlightingPairForRightChar(char c, @Nullable String currentSelector) {
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForLeftChar(char c, @Nullable String currentSelector) {
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        pairs.addAll(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.leftChar) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair getSmartTypingPairForRightChar(char c, @Nullable String currentSelector) {
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        pairs.addAll(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
        for (TextMateBracePair pair : pairs) {
            if (c != pair.rightChar) continue;
            return pair;
        }
        return null;
    }

    private static Set<TextMateBracePair> getAllPairsForMatcher(@Nullable String selector) {
        HashSet result = ContainerUtil.newHashSet();
        if (selector != null) {
            List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferencesForSelector(selector);
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> highlightingPairs = preferences.getHighlightingPairs();
                if (highlightingPairs == null) continue;
                if (highlightingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                result.addAll(highlightingPairs);
            }
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                result.addAll(preferences.getSmartTypingPairs());
            }
        }
        result.addAll(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        return result;
    }

    private static Set<TextMateBracePair> getSmartTypingPairs(@Nullable String currentSelector) {
        if (currentSelector != null) {
            List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferencesForSelector(currentSelector);
            for (Preferences preferences : preferencesForSelector) {
                Set<TextMateBracePair> smartTypingPairs = preferences.getSmartTypingPairs();
                if (smartTypingPairs == null) continue;
                if (smartTypingPairs.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet result = ContainerUtil.newHashSet(smartTypingPairs);
                result.addAll(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
                return result;
            }
        }
        return ContainerUtil.newHashSet(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private TextMateEditorUtils() {
    }
}

