/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.editor.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesReadUtil {
    @Nullable
    public static Pair<String, Plist> retrieveSettingsPlist(Plist rootPlist) {
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (StringUtil.isNotEmpty((String)scopeName) && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return settingsValuePlist != null ? Pair.create((Object)scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public static Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        if (pairsValue == null) {
            return null;
        }
        HashSet result = ContainerUtil.newHashSet();
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            if (left.length() != 1 || right.length() != 1) continue;
            result.add(new TextMateBracePair(left.charAt(0), right.charAt(0)));
        }
        return result;
    }

    public static boolean fillTextAttributes(TextAttributes attributes, Plist settingsPlist, @Nullable Color backgroundColor) {
        boolean result = false;
        for (Map.Entry<String, PListValue> entry : settingsPlist.entries()) {
            String propertyName = entry.getKey();
            String value = entry.getValue().getString();
            if ("foreground".equalsIgnoreCase(propertyName)) {
                attributes.setForegroundColor(PreferencesReadUtil.getColor(value, null));
                result = true;
                continue;
            }
            if ("fontStyle".equalsIgnoreCase(propertyName)) {
                if ("italic".equalsIgnoreCase(value)) {
                    attributes.setFontType(2);
                } else if ("bold".equalsIgnoreCase(value)) {
                    attributes.setFontType(1);
                } else if ("underline".equalsIgnoreCase(value)) {
                    Color foregroundColor = attributes.getForegroundColor();
                    Color effectColor = foregroundColor != null ? foregroundColor : HighlighterColors.TEXT.getDefaultAttributes().getForegroundColor();
                    attributes.setEffectColor(effectColor);
                    attributes.setEffectType(EffectType.LINE_UNDERSCORE);
                } else {
                    attributes.setFontType(0);
                }
                result = true;
                continue;
            }
            if (!"background".equalsIgnoreCase(propertyName)) continue;
            attributes.setBackgroundColor(PreferencesReadUtil.getColor(value, backgroundColor));
            result = true;
        }
        return result;
    }

    @Nullable
    private static TextMateSnippet loadTextMateSnippet(@NotNull Plist plist, @NotNull String filePath) throws IOException {
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "loadTextMateSnippet"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "loadTextMateSnippet"));
        }
        String name = plist.getPlistValue("name", "").getString();
        String key = plist.getPlistValue("tabTrigger", "").getString();
        String content = plist.getPlistValue("content", "").getString();
        String scope = plist.getPlistValue("scope", "").getString();
        String description = plist.getPlistValue("description", "").getString();
        String uuid = plist.getPlistValue("uuid", "").getString();
        if (!key.isEmpty() && !content.isEmpty()) {
            if (name.isEmpty()) {
                name = key;
            }
            if (uuid.isEmpty()) {
                uuid = filePath + ":" + name;
            }
            return new TextMateSnippet(key, content, scope, name, description, uuid);
        }
        return null;
    }

    @Nullable
    private static TextMateSnippet loadSublimeSnippet(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "loadSublimeSnippet"));
        }
        return null;
    }

    public static double getBackgroundAlpha(Plist settingsPlist) {
        String background;
        PListValue value = settingsPlist.getPlistValue("background");
        if (value != null && (background = value.getString()).length() > 7) {
            return PreferencesReadUtil.parseAlpha(background.substring(StringUtil.startsWithChar((CharSequence)background, (char)'#') ? 7 : 6));
        }
        return -1.0;
    }

    private static Color getColor(@NotNull String value, @Nullable Color backgroundColor) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "getColor"));
        }
        if (value.length() > 7) {
            double alpha;
            int startOffset = StringUtil.startsWithChar((CharSequence)value, (char)'#') ? 1 : 0;
            Color color = ColorUtil.fromHex((String)value.substring(startOffset, startOffset + 6), null);
            if (color != null && backgroundColor != null && (alpha = PreferencesReadUtil.parseAlpha(value.substring(startOffset + 6))) > -1.0) {
                return ColorUtil.mix((Color)backgroundColor, (Color)color, (double)alpha);
            }
            return color;
        }
        return ColorUtil.fromHex((String)value, null);
    }

    private static double parseAlpha(String string) {
        try {
            return (double)Integer.parseInt(string, 16) / 256.0;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private PreferencesReadUtil() {
    }

    @Nullable
    public static TextMateSnippet loadSnippet(@NotNull File snippetFile, @NotNull Plist plist) throws IOException {
        if (snippetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snippetFile", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "loadSnippet"));
        }
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/PreferencesReadUtil", "loadSnippet"));
        }
        return FileUtilRt.extensionEquals((String)snippetFile.getName(), (String)"sublime-snippet") ? PreferencesReadUtil.loadSublimeSnippet(snippetFile) : PreferencesReadUtil.loadTextMateSnippet(plist, snippetFile.getAbsolutePath());
    }
}

