/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.editor.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;

public class SnippetsRegistry {
    @NotNull
    private final MultiMap<String, TextMateSnippet> mySnippets = MultiMap.create();

    public void register(@NotNull TextMateSnippet snippet) {
        if (snippet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snippet", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "register"));
        }
        this.mySnippets.putValue((Object)snippet.getKey(), (Object)snippet);
    }

    @NotNull
    public Collection<TextMateSnippet> findSnippet(@NotNull String key, @Nullable String scopeSelector) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "findSnippet"));
        }
        if (scopeSelector == null) {
            List<TextMateSnippet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "findSnippet"));
            }
            return list;
        }
        List<TextMateSnippet> list = new TextMateScopeComparator(scopeSelector).sortAndFilter(this.mySnippets.get((Object)key));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "findSnippet"));
        }
        return list;
    }

    @NotNull
    public Collection<TextMateSnippet> getAvailableSnippets(@Nullable String scopeSelector) {
        if (scopeSelector == null) {
            List<TextMateSnippet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "getAvailableSnippets"));
            }
            return list;
        }
        List<TextMateSnippet> list = new TextMateScopeComparator(scopeSelector).sortAndFilter(this.mySnippets.values());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/SnippetsRegistry", "getAvailableSnippets"));
        }
        return list;
    }

    public void clear() {
        this.mySnippets.clear();
    }
}

