/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeSelectorOwner;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigherImpl;

public class TextMateScopeComparator<T extends TextMateScopeSelectorOwner>
implements Comparator<T> {
    @NotNull
    private static final TextMateSelectorWeigher myWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    @NotNull
    private final String myScope;

    public TextMateScopeComparator(@NotNull String scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/textmate/language/TextMateScopeComparator", "<init>"));
        }
        this.myScope = scope;
    }

    @Override
    public int compare(T first, T second) {
        return myWeigher.weigh(first.getScopeSelector(), this.myScope) - myWeigher.weigh(second.getScopeSelector(), this.myScope);
    }

    @NotNull
    public List<T> sortAndFilter(@NotNull Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "org/jetbrains/plugins/textmate/language/TextMateScopeComparator", "sortAndFilter"));
        }
        List list = ContainerUtil.reverse((List)ContainerUtil.sorted((Collection)ContainerUtil.filter(objects, (Condition)new Condition<T>(){

            public boolean value(T t) {
                return myWeigher.weigh(t.getScopeSelector(), TextMateScopeComparator.this.myScope) > 0;
            }
        }), (Comparator)this));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/TextMateScopeComparator", "sortAndFilter"));
        }
        return list;
    }

    @Nullable
    public T max(Collection<T> objects) {
        int max = 0;
        TextMateScopeSelectorOwner result = null;
        for (TextMateScopeSelectorOwner object : objects) {
            int weigh = myWeigher.weigh(object.getScopeSelector(), this.myScope);
            if (weigh <= max) continue;
            max = weigh;
            result = object;
        }
        return (T)result;
    }
}

