/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.plist.Plist;

public class PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = ContainerUtil.newHashSet();

    public void fillFromPList(@NotNull String scopeName, @NotNull Plist plist) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry", "fillFromPList"));
        }
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry", "fillFromPList"));
        }
        Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("highlightingPairs"));
        Set<TextMateBracePair> smartTypingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("smartTypingPairs"));
        if (highlightingPairs != null || smartTypingPairs != null) {
            this.myPreferences.add(new Preferences(scopeName, highlightingPairs, smartTypingPairs));
        }
    }

    @NotNull
    public List<Preferences> getPreferences(@NotNull String scopeSelector) {
        if (scopeSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeSelector", "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry", "getPreferences"));
        }
        List<Preferences> list = new TextMateScopeComparator<Preferences>(scopeSelector).sortAndFilter(this.myPreferences);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry", "getPreferences"));
        }
        return list;
    }

    public void clear() {
        this.myPreferences.clear();
    }
}

