/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.TextMateScopeSelectorOwner;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class ShellVariablesRegistry {
    @NotNull
    private final MultiMap<String, TextMateShellVariable> myVariables = MultiMap.create();

    public void fillVariablesFromPlist(@NotNull String scopeName, @NotNull Plist plist) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry", "fillVariablesFromPlist"));
        }
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry", "fillVariablesFromPlist"));
        }
        PListValue shellVariables = plist.getPlistValue("shellVariables");
        if (shellVariables != null) {
            for (PListValue variable : shellVariables.getArray()) {
                Plist variablePlist = variable.getPlist();
                String name = variablePlist.getPlistValue("name", "").getString();
                String value = variablePlist.getPlistValue("value", "").getString();
                if (name.isEmpty()) continue;
                this.myVariables.putValue((Object)name, (Object)new TextMateShellVariable(scopeName, name, value));
            }
        }
    }

    @Nullable
    public String getVariableValue(@NotNull String name, @Nullable String scopeSelector) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry", "getVariableValue"));
        }
        if (scopeSelector == null) {
            return null;
        }
        TextMateShellVariable variable = (TextMateShellVariable)new TextMateScopeComparator(scopeSelector).max(this.myVariables.get((Object)name));
        return variable != null ? variable.value : null;
    }

    public void clear() {
        this.myVariables.clear();
    }

    public static class TextMateShellVariable
    implements TextMateScopeSelectorOwner {
        public final String scopeName;
        public final String name;
        public final String value;

        public TextMateShellVariable(@NotNull String scopeName, @NotNull String name, @NotNull String value) {
            if (scopeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry$TextMateShellVariable", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry$TextMateShellVariable", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry$TextMateShellVariable", "<init>"));
            }
            this.scopeName = scopeName;
            this.name = name;
            this.value = value;
        }

        @Override
        @NotNull
        public String getScopeSelector() {
            String string = this.scopeName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry$TextMateShellVariable", "getScopeSelector"));
            }
            return string;
        }
    }
}

