/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

class SyntaxNodeDescriptorImpl
implements MutableSyntaxNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(SyntaxNodeDescriptor.class);
    private final Map<String, String> myStringAttributes = ContainerUtil.newHashMap();
    private final Map<String, RegexFacade> myRegexAttributes = ContainerUtil.newHashMap();
    private final Map<String, Plist> myPlistAttributes = ContainerUtil.newHashMap();
    private final List<SyntaxNodeDescriptor> myChildren = ContainerUtil.newArrayList();
    private final Map<String, SyntaxNodeDescriptor> myRepository = ContainerUtil.newHashMap();
    private final SyntaxNodeDescriptor myParentNode;
    private String myScopeName = "";

    public SyntaxNodeDescriptorImpl(@Nullable SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
    }

    @Override
    public void setStringAttribute(String key, String value) {
        this.myStringAttributes.put(key, value);
    }

    @Override
    @Nullable
    public String getStringAttribute(String key) {
        return this.myStringAttributes.get(key);
    }

    @Override
    public void setPlistAttribute(String key, Plist value) {
        this.myPlistAttributes.put(key, value);
    }

    @Override
    @Nullable
    public Plist getPlistAttribute(String key) {
        return this.myPlistAttributes.get(key);
    }

    @Override
    public void setRegexAttribute(String key, RegexFacade value) {
        this.myRegexAttributes.put(key, value);
    }

    @Override
    @Nullable
    public RegexFacade getRegexAttribute(String key) {
        return this.myRegexAttributes.get(key);
    }

    @Override
    public void addChild(SyntaxNodeDescriptor descriptor) {
        this.myChildren.add(descriptor);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "getChildren"));
        }
        return list;
    }

    @Override
    public void appendRepository(String key, SyntaxNodeDescriptor descriptor) {
        this.myRepository.put(key, descriptor);
    }

    @Override
    public void setScopeName(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "setScopeName"));
        }
        this.myScopeName = scopeName;
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(String key) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRepository.get(key);
        if (syntaxNodeDescriptor == null && this.myParentNode != null) {
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = this.myParentNode.findInRepository(key);
            if (syntaxNodeDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "findInRepository"));
            }
            return syntaxNodeDescriptor2;
        }
        if (syntaxNodeDescriptor == null) {
            LOG.warn("Can't find repository '" + key + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor3 = EMPTY_NODE;
            if (syntaxNodeDescriptor3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "findInRepository"));
            }
            return syntaxNodeDescriptor3;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor4 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "findInRepository"));
        }
        return syntaxNodeDescriptor4;
    }

    @Override
    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl", "getScopeName"));
        }
        return string;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    public String toString() {
        String name = this.myStringAttributes.get("name");
        return name != null ? "Syntax rule: " + name : super.toString();
    }
}

