/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

class SyntaxProxyDescriptor
implements SyntaxNodeDescriptor {
    private final String proxyName;
    private final SyntaxNodeDescriptor myParentNode;
    private final SyntaxNodeDescriptor myRootNode;
    private final TextMateSyntaxTable mySyntaxTable;

    public SyntaxProxyDescriptor(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor parentNode, @NotNull SyntaxNodeDescriptor rootNode, @NotNull TextMateSyntaxTable syntaxTable) {
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "<init>"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "<init>"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "<init>"));
        }
        if (syntaxTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxTable", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "<init>"));
        }
        this.myRootNode = rootNode;
        this.mySyntaxTable = syntaxTable;
        this.proxyName = plist.getPlistValue("include", "").getString();
        this.myParentNode = parentNode;
    }

    @Override
    @Nullable
    public String getStringAttribute(String key) {
        return this.getTargetNode().getStringAttribute(key);
    }

    @Override
    @Nullable
    public Plist getPlistAttribute(String key) {
        return this.getTargetNode().getPlistAttribute(key);
    }

    @Override
    @Nullable
    public RegexFacade getRegexAttribute(String key) {
        return this.getTargetNode().getRegexAttribute(key);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.getTargetNode().getChildren();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getChildren"));
        }
        return list;
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(String key) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.getTargetNode().findInRepository(key);
        if (syntaxNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "findInRepository"));
        }
        return syntaxNodeDescriptor;
    }

    @Override
    @NotNull
    public String getScopeName() {
        String string = this.getTargetNode().getScopeName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getScopeName"));
        }
        return string;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    @NotNull
    private SyntaxNodeDescriptor getTargetNode() {
        if (this.proxyName.startsWith("#")) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myParentNode.findInRepository(this.proxyName.substring(1));
            if (syntaxNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getTargetNode"));
            }
            return syntaxNodeDescriptor;
        }
        if ("$self".equalsIgnoreCase(this.proxyName)) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRootNode;
            if (syntaxNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getTargetNode"));
            }
            return syntaxNodeDescriptor;
        }
        if ("$base".equalsIgnoreCase(this.proxyName)) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRootNode;
            if (syntaxNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getTargetNode"));
            }
            return syntaxNodeDescriptor;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.mySyntaxTable.getSyntax(this.proxyName);
        if (syntaxNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor", "getTargetNode"));
        }
        return syntaxNodeDescriptor;
    }

    public String toString() {
        return "Proxy rule for '" + this.proxyName + "'";
    }
}

