/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptorImpl;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxProxyDescriptor;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.joni.exception.JOniException;

public class TextMateSyntaxTable {
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxTable.class);
    private final Map<String, SyntaxNodeDescriptor> rulesMap = ContainerUtil.newHashMap();

    @NotNull
    public String loadSyntax(Plist plist) {
        SyntaxNodeDescriptor rootSyntaxNode = this.loadRealNode(plist, null);
        String string = rootSyntaxNode.getScopeName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "loadSyntax"));
        }
        return string;
    }

    @NotNull
    public SyntaxNodeDescriptor getSyntax(String scopeName) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rulesMap.get(scopeName);
        if (syntaxNodeDescriptor == null) {
            LOG.debug("Can't find syntax node for scope: '" + scopeName + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = SyntaxNodeDescriptor.EMPTY_NODE;
            if (syntaxNodeDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "getSyntax"));
            }
            return syntaxNodeDescriptor2;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor3 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "getSyntax"));
        }
        return syntaxNodeDescriptor3;
    }

    public void clear() {
        this.rulesMap.clear();
    }

    private SyntaxNodeDescriptor loadNestedSyntax(Plist plist, SyntaxNodeDescriptor parentNode) {
        return plist.contains("include") ? this.loadProxyNode(plist, parentNode) : this.loadRealNode(plist, parentNode);
    }

    @NotNull
    private SyntaxNodeDescriptor loadRealNode(Plist plist, SyntaxNodeDescriptor parentNode) {
        SyntaxNodeDescriptorImpl result = new SyntaxNodeDescriptorImpl(parentNode);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue pListValue = entry.getValue();
            if (pListValue == null) continue;
            String key = entry.getKey();
            if (ArrayUtil.contains((String)key, (String[])Constants.REGEX_KEY_NAMES)) {
                try {
                    String pattern = pListValue.getString();
                    if (pattern == null) continue;
                    result.setRegexAttribute(key, RegexFacade.regex(pattern));
                }
                catch (JOniException e) {
                    LOG.error("Cannot compile pattern '" + pListValue.getString() + "' for '" + key + "'", (Throwable)e);
                }
                continue;
            }
            if (ArrayUtil.contains((String)key, (String[])Constants.STRING_KEY_NAMES)) {
                result.setStringAttribute(key, pListValue.getString());
                continue;
            }
            if (ArrayUtil.contains((String)key, (String[])Constants.DICT_KEY_NAMES)) {
                result.setPlistAttribute(key, pListValue.getPlist());
                continue;
            }
            if ("repository".equalsIgnoreCase(key)) {
                this.loadRepository(result, pListValue);
                continue;
            }
            if (!"patterns".equalsIgnoreCase(key)) continue;
            this.loadPatterns(result, pListValue);
        }
        if (plist.contains("scopeName")) {
            String scopeName = plist.getPlistValue("scopeName", "default").getString();
            result.setScopeName(scopeName);
            this.rulesMap.put(scopeName, result);
        }
        SyntaxNodeDescriptorImpl syntaxNodeDescriptorImpl = result;
        if (syntaxNodeDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "loadRealNode"));
        }
        return syntaxNodeDescriptorImpl;
    }

    private SyntaxNodeDescriptor loadProxyNode(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor result) {
        if (plist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plist", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "loadProxyNode"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "loadProxyNode"));
        }
        SyntaxNodeDescriptor rootNode = TextMateSyntaxTable.findRootNode(result);
        return new SyntaxProxyDescriptor(plist, result, rootNode, this);
    }

    private void loadPatterns(MutableSyntaxNodeDescriptor result, PListValue pListValue) {
        for (PListValue value : pListValue.getArray()) {
            result.addChild(this.loadNestedSyntax(value.getPlist(), result));
        }
    }

    private void loadRepository(MutableSyntaxNodeDescriptor result, PListValue pListValue) {
        for (Map.Entry<String, PListValue> repoEntry : pListValue.getPlist().entries()) {
            PListValue repoEntryValue = repoEntry.getValue();
            if (repoEntryValue == null) continue;
            Plist plist = repoEntryValue.getPlist();
            result.appendRepository(repoEntry.getKey(), this.loadNestedSyntax(plist, result));
        }
    }

    @NotNull
    private static SyntaxNodeDescriptor findRootNode(@NotNull SyntaxNodeDescriptor result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "findRootNode"));
        }
        SyntaxNodeDescriptor rootNode = result;
        SyntaxNodeDescriptor parentNode = result;
        while (parentNode != null) {
            rootNode = parentNode;
            parentNode = rootNode.getParentNode();
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor = rootNode;
        if (syntaxNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable", "findRootNode"));
        }
        return syntaxNodeDescriptor;
    }
}

