/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;

public class TextMateHighlighter
extends SyntaxHighlighterBase {
    private final Lexer myLexer;
    private final TextMateSelectorWeigher mySelectorWeigher;

    public TextMateHighlighter(Lexer lexer) {
        this.myLexer = lexer;
        this.mySelectorWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter", "getHighlightingLexer"));
        }
        return lexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextMateService service = TextMateService.getInstance();
        Map<String, TextMateCustomTextAttributes> customHighlightingColors = service.getCustomHighlightingColors();
        TextMateTheme theme = service.getCurrentTheme();
        List highlightingRules = ContainerUtil.newSmartList((Object)new HighlightingRule("textmate.default", 0));
        for (String currentRule : ContainerUtil.union(customHighlightingColors.keySet(), theme.getRules())) {
            int weigh = this.mySelectorWeigher.weigh(currentRule, tokenType.toString());
            if (weigh <= 0) continue;
            highlightingRules.add(new HighlightingRule(currentRule, weigh));
        }
        ContainerUtil.sort((List)highlightingRules);
        TextAttributesKey[] textAttributesKeyArray = (TextAttributesKey[])ContainerUtil.map2Array((Collection)highlightingRules, TextAttributesKey.class, rule -> {
            TextMateCustomTextAttributes customTextAttributes = (TextMateCustomTextAttributes)customHighlightingColors.get(rule.myName);
            if (customTextAttributes != null) {
                double backgroundAlpha;
                Color defaultBackground;
                TextAttributes textAttributes = customTextAttributes.getTextAttributes();
                Color backgroundColor = textAttributes.getBackgroundColor();
                if (backgroundColor != null && (defaultBackground = theme.getDefaultBackground()) != null && (backgroundAlpha = customTextAttributes.getBackgroundAlpha()) > -1.0) {
                    textAttributes.setBackgroundColor(ColorUtil.mix((Color)defaultBackground, (Color)backgroundColor, (double)backgroundAlpha));
                    return TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + theme.getName() + rule.myName), (TextAttributes)textAttributes);
                }
                return TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + rule.myName), (TextAttributes)textAttributes);
            }
            return theme.getTextAttributesKey(rule.myName);
        });
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    private static class HighlightingRule
    implements Comparable<HighlightingRule> {
        public final String myName;
        private final int myWeigh;

        public HighlightingRule(String name, int weigh) {
            this.myName = name;
            this.myWeigh = weigh;
        }

        @Override
        public int compareTo(@NotNull HighlightingRule rule) {
            if (rule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter$HighlightingRule", "compareTo"));
            }
            return this.myWeigh - rule.myWeigh;
        }
    }
}

