/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigher;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    @NotNull
    private final Cache<String, Integer> myCache;
    private static final Logger LOG = Logger.getInstance(TextMateSelectorCachingWeigher.class);

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        if (originalWeigher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalWeigher", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher", "<init>"));
        }
        this.myCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(200L).build();
        this.myOriginalWeigher = originalWeigher;
    }

    @Override
    public int weigh(@NotNull String scopeSelector, @NotNull String scope) {
        if (scopeSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeSelector", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher", "weigh"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher", "weigh"));
        }
        try {
            return (Integer)this.myCache.get((Object)TextMateSelectorCachingWeigher.createCacheKey(scopeSelector, scope), () -> {
                if (scopeSelector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeSelector", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher", "lambda$weigh$0"));
                }
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher", "lambda$weigh$0"));
                }
                return this.myOriginalWeigher.weigh(scopeSelector, scope);
            });
        }
        catch (ExecutionException e) {
            LOG.error("Can't perform lazy weigh for textmate selectors", (Throwable)e);
            return this.myOriginalWeigher.weigh(scopeSelector, scope);
        }
    }

    private static String createCacheKey(String highlightingRule, String targetSelector) {
        return highlightingRule + ";" + targetSelector;
    }
}

