/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateHighlighter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateHighlightingLexer;

public class TextMateSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private static final PlainSyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new PlainSyntaxHighlighter();

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        TextMateLanguageDescriptor languageDescriptor;
        if (virtualFile == null) {
            PlainSyntaxHighlighter plainSyntaxHighlighter = PLAIN_SYNTAX_HIGHLIGHTER;
            if (plainSyntaxHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSyntaxHighlighterFactory", "getSyntaxHighlighter"));
            }
            return plainSyntaxHighlighter;
        }
        TextMateService textMateService = TextMateService.getInstance();
        if (textMateService != null && (languageDescriptor = textMateService.getLanguageDescriptorByFileName(virtualFile.getName())) != null) {
            Logger.getInstance(((Object)((Object)this)).getClass()).debug("Textmate highlighting: " + virtualFile.getPath());
            TextMateHighlighter textMateHighlighter = new TextMateHighlighter((Lexer)new TextMateHighlightingLexer(languageDescriptor.getScopeName(), languageDescriptor.getRootSyntaxNode()));
            if (textMateHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSyntaxHighlighterFactory", "getSyntaxHighlighter"));
            }
            return textMateHighlighter;
        }
        PlainSyntaxHighlighter plainSyntaxHighlighter = PLAIN_SYNTAX_HIGHLIGHTER;
        if (plainSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return plainSyntaxHighlighter;
    }
}

