/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateDefaultColorsProvider;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateTheme {
    public static final String DEFAULT_ATTRIBUTES_NAME = "textmate.default";
    public static final TextMateTheme EMPTY_THEME = new TextMateTheme("Unnamed", ContainerUtil.newHashMap(), TextAttributes.ERASE_MARKER);
    private final String name;
    private final Map<String, TextAttributes> myTextAttributes;
    private final TextAttributes myDefaultAttributes;
    private final TextMateDefaultColorsProvider defaultColorsProvider = new TextMateDefaultColorsProvider();

    private TextMateTheme(String name, Map<String, TextAttributes> textAttributes, TextAttributes defaultAttributes) {
        this.name = name;
        this.myTextAttributes = textAttributes;
        this.myDefaultAttributes = defaultAttributes;
        this.initDefaultColors();
    }

    private void initDefaultColors() {
        for (String key : this.defaultColorsProvider.getAllDefaultKeys()) {
            if (this.myTextAttributes.containsKey(key)) continue;
            this.myTextAttributes.put(key, this.defaultColorsProvider.getTextAttributes(key));
        }
    }

    public Color getDefaultBackground() {
        return this.myDefaultAttributes.getBackgroundColor();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRules() {
        return this.myTextAttributes.keySet();
    }

    public TextAttributesKey getTextAttributesKey(String highlightingRule) {
        String key = this.getName() + "." + highlightingRule;
        return TextAttributesKey.createTextAttributesKey((String)key, (TextAttributes)this.getTextAttributes(highlightingRule));
    }

    private TextAttributes getTextAttributes(String highlightingRule) {
        return this.myTextAttributes.containsKey(highlightingRule) ? this.myTextAttributes.get(highlightingRule) : this.myDefaultAttributes;
    }

    @NotNull
    public static TextMateTheme load(Plist plist) {
        String themeName = plist.getPlistValue("name", "Unnamed").getString();
        HashMap attributes = ContainerUtil.newHashMap();
        PListValue settings = plist.getPlistValue("settings");
        if (settings == null) {
            TextMateTheme textMateTheme = EMPTY_THEME;
            if (textMateTheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTheme", "load"));
            }
            return textMateTheme;
        }
        TextAttributes defaultAttributes = new TextAttributes();
        for (PListValue colorDefinition : settings.getArray()) {
            Plist colorDefinitionPlist = colorDefinition.getPlist();
            String scope = colorDefinitionPlist.getPlistValue("scope", "").getString();
            Plist colorRuleSettings = colorDefinitionPlist.getPlistValue("settings", Plist.EMPTY_PLIST).getPlist();
            if (scope.isEmpty()) {
                PreferencesReadUtil.fillTextAttributes(defaultAttributes, colorRuleSettings, defaultAttributes.getBackgroundColor());
                continue;
            }
            TextAttributes textAttributes = new TextAttributes();
            PreferencesReadUtil.fillTextAttributes(textAttributes, colorRuleSettings, defaultAttributes.getBackgroundColor());
            attributes.put(scope, textAttributes);
        }
        TextMateTheme textMateTheme = new TextMateTheme(themeName, attributes, defaultAttributes);
        if (textMateTheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTheme", "load"));
        }
        return textMateTheme;
    }
}

