/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

class CaptureMatchData {
    public static final Comparator<CaptureMatchData> START_OFFSET_ORDERING = (o1, o2) -> {
        int result = Comparing.compare((int)o2.offset.getStartOffset(), (int)o1.offset.getStartOffset());
        return result != 0 ? result : Comparing.compare((Comparable)o2.group, (Comparable)o1.group);
    };
    public static final Comparator<CaptureMatchData> END_OFFSET_ORDERING = (o1, o2) -> {
        int result = Comparing.compare((int)o2.offset.getEndOffset(), (int)o1.offset.getEndOffset());
        return result != 0 ? result : Comparing.compare((Comparable)o1.group, (Comparable)o2.group);
    };
    public final TextRange offset;
    public final Integer group;
    public final String selectorName;

    public CaptureMatchData(@NotNull TextRange offset, @NotNull Integer group, @NotNull String selectorName) {
        if (offset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offset", "org/jetbrains/plugins/textmate/language/syntax/lexer/CaptureMatchData", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/plugins/textmate/language/syntax/lexer/CaptureMatchData", "<init>"));
        }
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "org/jetbrains/plugins/textmate/language/syntax/lexer/CaptureMatchData", "<init>"));
        }
        this.offset = offset;
        this.group = group;
        this.selectorName = selectorName;
    }
}

