/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

public final class SyntaxMatchUtils {
    private static final Pattern DIGIT_GROUP_REGEX = Pattern.compile("\\\\([0-9]+)");

    @NotNull
    public static TextMateLexerState matchFirst(SyntaxNodeDescriptor syntaxNodeDescriptor, String line, int position) {
        TextMateLexerState resultState = new TextMateLexerState(syntaxNodeDescriptor, MatchData.NOT_MATCHED);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        for (SyntaxNodeDescriptor child : children) {
            resultState = SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchFirstChild(child, line, position));
        }
        TextMateLexerState textMateLexerState = resultState;
        if (textMateLexerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "matchFirst"));
        }
        return textMateLexerState;
    }

    @NotNull
    private static TextMateLexerState moreImportantState(@NotNull TextMateLexerState oldState, @NotNull TextMateLexerState newState) {
        if (oldState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldState", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
        }
        if (newState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
        }
        if (!oldState.matchData.matched()) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
            }
            return textMateLexerState;
        }
        if (!newState.matchData.matched()) {
            TextMateLexerState textMateLexerState = oldState;
            if (textMateLexerState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
            }
            return textMateLexerState;
        }
        if (newState.matchData.offset().getStartOffset() < oldState.matchData.offset().getStartOffset() && (!newState.matchData.offset().isEmpty() || oldState.matchData.offset().isEmpty() || SyntaxMatchUtils.hasBeginKey(newState))) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
            }
            return textMateLexerState;
        }
        TextMateLexerState textMateLexerState = oldState;
        if (textMateLexerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "moreImportantState"));
        }
        return textMateLexerState;
    }

    private static boolean hasBeginKey(@NotNull TextMateLexerState lexerState) {
        if (lexerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexerState", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "hasBeginKey"));
        }
        return lexerState.syntaxRule.getRegexAttribute("begin") != null;
    }

    private static TextMateLexerState matchFirstChild(SyntaxNodeDescriptor syntaxNodeDescriptor, String line, int position) {
        RegexFacade matchRegex = syntaxNodeDescriptor.getRegexAttribute("match");
        if (matchRegex != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, matchRegex.match(line, position));
        }
        RegexFacade beginRegex = syntaxNodeDescriptor.getRegexAttribute("begin");
        if (beginRegex != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, beginRegex.match(line, position));
        }
        if (syntaxNodeDescriptor.getStringAttribute("end") != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, MatchData.NOT_MATCHED);
        }
        return SyntaxMatchUtils.matchFirst(syntaxNodeDescriptor, line, position);
    }

    public static List<CaptureMatchData> matchCaptures(@NotNull Plist captures, @NotNull MatchData matchData) {
        if (captures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captures", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "matchCaptures"));
        }
        if (matchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchData", "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils", "matchCaptures"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Map.Entry<String, PListValue> capture : captures.entries()) {
            try {
                TextRange offset;
                Integer index = Integer.parseInt(capture.getKey(), 10);
                Plist captureDict = capture.getValue().getPlist();
                String captureName = captureDict.getPlistValue("name", "").getString();
                TextRange textRange = offset = index < matchData.count() ? matchData.offset(index) : TextRange.EMPTY_RANGE;
                if (captureName.isEmpty() || offset.getLength() <= 0) continue;
                result.add(new CaptureMatchData(offset, index, captureName));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static MatchData matchStringRegex(String keyName, String line, TextMateLexerState lexerState, int linePosition) {
        String stringRegex = lexerState.syntaxRule.getStringAttribute(keyName);
        return stringRegex != null ? RegexFacade.regex(SyntaxMatchUtils.replaceGroupsWithMatchData(stringRegex, lexerState.matchData)).match(line, linePosition) : MatchData.NOT_MATCHED;
    }

    public static String replaceGroupsWithMatchData(String patternString, MatchData matchData) {
        Matcher matcher = DIGIT_GROUP_REGEX.matcher(patternString);
        StringBuilder result = new StringBuilder();
        int lastPosition = 0;
        while (matcher.find()) {
            int groupIndex = StringUtil.parseInt((String)matcher.group(1), (int)-1);
            if (groupIndex < 0 || matchData.count() <= groupIndex) continue;
            result.append(patternString.substring(lastPosition, matcher.start()));
            StringUtil.escapeToRegexp((CharSequence)matchData.capture(groupIndex), (StringBuilder)result);
            lastPosition = matcher.end();
        }
        if (lastPosition < patternString.length()) {
            result.append(patternString.substring(lastPosition));
        }
        return result.toString();
    }
}

