/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.TextMateLanguage;

public class TextMateElementType
extends IElementType {
    private static final Joiner MY_OPEN_TAGS_JOINER = Joiner.on((String)" ").skipNulls();
    private static final LoadingCache<String, TextMateElementType> ourCache = CacheBuilder.newBuilder().initialCapacity(100).build(CacheLoader.from((Function)new Function<String, TextMateElementType>(){

        public TextMateElementType apply(String input) {
            return new TextMateElementType(input);
        }
    }));
    private static final Logger LOG = Logger.getInstance(TextMateElementType.class);

    private TextMateElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateElementType", "<init>"));
        }
        super(debugName, (Language)TextMateLanguage.LANGUAGE);
    }

    public static TextMateElementType getOrCreate(List<String> selectors) {
        String selector = MY_OPEN_TAGS_JOINER.join(selectors);
        try {
            return (TextMateElementType)((Object)ourCache.get((Object)selector));
        }
        catch (ExecutionException e) {
            LOG.error("Can't perform lazy creating of TextMate element type", (Throwable)e);
            return new TextMateElementType(selector);
        }
    }
}

