/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class XmlPlistReader
implements PlistReader {
    @Override
    public Plist read(InputStream inputStream) throws IOException {
        try {
            Document document = JDOMUtil.loadDocument((InputStream)inputStream);
            return XmlPlistReader.internalRead(document);
        }
        catch (JDOMException e) {
            throw new IOException("Error while parsing plist", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plist read(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Plist plist = this.read(fileInputStream);
            return plist;
        }
    }

    private static Plist internalRead(Document document) throws IOException {
        if (!document.hasRootElement()) {
            return Plist.EMPTY_PLIST;
        }
        Element root = document.getRootElement();
        if (!"plist".equals(root.getName())) {
            throw new IOException("Unknown xml format. Root element is '" + root.getName() + "'");
        }
        Element dictElement = root.getChild("dict");
        return dictElement != null ? (Plist)XmlPlistReader.readDict(dictElement).getValue() : Plist.EMPTY_PLIST;
    }

    private static PListValue readDict(Element dictElement) throws IOException {
        Plist dict = new Plist();
        List children = dictElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element valueElement;
            PListValue value;
            Object cOdd;
            Element keyElement;
            Object cEven = children.get(i);
            if (!(cEven instanceof Element) || !"key".equals((keyElement = (Element)cEven).getName())) continue;
            String attributeKey = keyElement.getValue();
            if (!((cOdd = children.get(++i)) instanceof Element) || (value = XmlPlistReader.readValue(attributeKey, valueElement = (Element)cOdd)) == null) continue;
            dict.setEntry(attributeKey, value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(@NotNull String key, @NotNull Element valueElement) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/textmate/plist/XmlPlistReader", "readValue"));
        }
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "org/jetbrains/plugins/textmate/plist/XmlPlistReader", "readValue"));
        }
        String type = valueElement.getName();
        if ("dict".equals(type)) {
            return XmlPlistReader.readDict(valueElement);
        }
        if ("array".equals(type)) {
            return XmlPlistReader.readArray(key, valueElement);
        }
        return XmlPlistReader.readBasicValue(type, valueElement);
    }

    private static PListValue readArray(String key, Element element) throws IOException {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (Object child : element.getChildren()) {
            Element childElement;
            PListValue val;
            if (!(child instanceof Element) || (val = XmlPlistReader.readValue(key, childElement = (Element)child)) == null) continue;
            result.add(val);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(@NotNull String type, @NotNull Element valueElement) throws IOException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/textmate/plist/XmlPlistReader", "readBasicValue"));
        }
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "org/jetbrains/plugins/textmate/plist/XmlPlistReader", "readBasicValue"));
        }
        if ("string".equals(type)) {
            return PListValue.value(StringUtil.unescapeXml((String)valueElement.getValue()), PlistValueType.STRING);
        }
        if ("true".equals(type)) {
            return PListValue.value(Boolean.TRUE, PlistValueType.BOOLEAN);
        }
        if ("false".equals(type)) {
            return PListValue.value(Boolean.FALSE, PlistValueType.BOOLEAN);
        }
        if ("integer".equals(type)) {
            return PListValue.value(Long.parseLong(valueElement.getValue()), PlistValueType.INTEGER);
        }
        if ("real".equals(type)) {
            return PListValue.value(Double.parseDouble(valueElement.getValue()), PlistValueType.REAL);
        }
        if ("date".equals(type)) {
            try {
                return PListValue.value(Plist.dateFormatter().parse(valueElement.getValue()), PlistValueType.DATE);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

